/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.der;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.BERConstructedOctetString;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;
import org.apache.directory.shared.i18n.I18n;

public class BERTaggedObject
extends DERTaggedObject {
    public BERTaggedObject(int tag, DEREncodable obj) {
        super(tag, obj);
    }

    public BERTaggedObject(boolean explicit, int tag, DEREncodable obj) {
        super(explicit, tag, obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(ASN1OutputStream out) throws IOException {
        out.write(0xA0 | this.tag);
        out.write(128);
        if (!this.empty) {
            if (!this.explicit) {
                if (this.obj instanceof DEROctetString) {
                    Enumeration<DEREncodable> e;
                    if (this.obj instanceof BERConstructedOctetString) {
                        e = ((BERConstructedOctetString)this.obj).getObjects();
                    } else {
                        DEROctetString octs = (DEROctetString)this.obj;
                        BERConstructedOctetString berO = new BERConstructedOctetString(octs.getOctets());
                        e = berO.getObjects();
                    }
                    while (e.hasMoreElements()) {
                        out.writeObject(e.nextElement());
                    }
                } else {
                    if (!(this.obj instanceof DERSequence)) throw new RuntimeException(I18n.err((I18n)I18n.ERR_00027_NOT_IMPLEMENTED, (Object[])new Object[]{this.obj.getClass().getName()}));
                    Enumeration<DEREncodable> e = ((DERSequence)this.obj).getObjects();
                    while (e.hasMoreElements()) {
                        out.writeObject(e.nextElement());
                    }
                }
            } else {
                out.writeObject(this.obj);
            }
        }
        out.write(0);
        out.write(0);
    }
}

