/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.grammar;

import org.apache.directory.shared.asn1.ber.grammar.Action;
import org.apache.directory.shared.asn1.ber.grammar.States;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;

public class GrammarTransition {
    private Action action;
    private int previousState;
    private int currentState;
    private int currentTag;

    public GrammarTransition(int previousState, int currentState, int currentTag, Action action) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.action = action;
        this.currentTag = currentTag;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public Action getAction() {
        return this.action;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public String toString(States statesEnum) {
        StringBuilder sb = new StringBuilder();
        sb.append("Transition from state <").append(statesEnum.getState(this.previousState)).append("> ");
        sb.append("to state <").append(statesEnum.getState(this.currentState)).append(">, ");
        sb.append("tag <").append(Asn1StringUtils.dumpByte((byte)this.currentTag)).append(">, ");
        sb.append("action : ");
        if (this.action == null) {
            sb.append("no action");
        } else {
            sb.append(this.action);
        }
        return sb.toString();
    }
}

