/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.grammar;

import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.Action;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.States;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGrammar
implements Grammar {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGrammar.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    protected GrammarTransition[][] transitions;
    private String name;
    private States statesEnum;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GrammarTransition getTransition(int state, int tag) {
        return this.transitions[state][tag & 0xFF];
    }

    public void executeAction(Asn1Container container) throws DecoderException {
        int currentState = container.getTransition();
        Grammar currentGrammar = container.getGrammar();
        if (currentState == -1) {
            return;
        }
        byte tagByte = container.getCurrentTLV().getTag();
        GrammarTransition transition = ((AbstractGrammar)container.getGrammar()).getTransition(currentState, tagByte);
        if (transition == null) {
            String errorMessage = I18n.err((I18n)I18n.ERR_00001_BAD_TRANSITION_FROM_STATE, (Object[])new Object[]{currentGrammar.getStatesEnum().getState(currentState), Asn1StringUtils.dumpByte(tagByte)});
            LOG.error(errorMessage);
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00002_BAD_TRANSITION, (Object[])new Object[0]));
        }
        if (IS_DEBUG) {
            LOG.debug(transition.toString(currentGrammar.getStatesEnum()));
        }
        if (transition.hasAction()) {
            Action action = transition.getAction();
            action.action(container);
        }
        container.setTransition(transition.getCurrentState());
    }

    public States getStatesEnum() {
        return this.statesEnum;
    }

    public void setStatesEnum(States statesEnum) {
        this.statesEnum = statesEnum;
    }
}

