/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber;

import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.States;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.TLVStateEnum;

public abstract class AbstractContainer
implements Asn1Container {
    protected Grammar grammar;
    protected int[] stateStack;
    private TLVStateEnum state;
    private int transition;
    private TLV tlv;
    protected States states;
    private TLV parentTLV;
    private boolean grammarEndAllowed;
    protected int decodeBytes;
    private int maxPDUSize = Integer.MAX_VALUE;
    private int id = 0;

    protected AbstractContainer() {
        this.state = TLVStateEnum.TAG_STATE_START;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public TLVStateEnum getState() {
        return this.state;
    }

    public void setState(TLVStateEnum state) {
        this.state = state;
    }

    public boolean isGrammarEndAllowed() {
        return this.grammarEndAllowed;
    }

    public void grammarEndAllowed(boolean grammarEndAllowed) {
        this.grammarEndAllowed = grammarEndAllowed;
    }

    public int getTransition() {
        return this.transition;
    }

    public void setTransition(int transition) {
        this.transition = transition;
    }

    public void setCurrentTLV(TLV tlv) {
        this.tlv = tlv;
    }

    public TLV getCurrentTLV() {
        return this.tlv;
    }

    public States getStates() {
        return this.states;
    }

    public TLV getParentTLV() {
        return this.parentTLV;
    }

    public void setParentTLV(TLV parentTLV) {
        this.parentTLV = parentTLV;
    }

    public void clean() {
        this.tlv = null;
        this.parentTLV = null;
        this.transition = 0;
        this.state = TLVStateEnum.TAG_STATE_START;
    }

    public int getNewTlvId() {
        return this.id++;
    }

    public int getTlvId() {
        return this.tlv.getId();
    }

    public int getDecodeBytes() {
        return this.decodeBytes;
    }

    public void incrementDecodeBytes(int nb) {
        this.decodeBytes += nb;
    }

    public int getMaxPDUSize() {
        return this.maxPDUSize;
    }

    public void setMaxPDUSize(int maxPDUSize) {
        this.maxPDUSize = maxPDUSize > 0 ? maxPDUSize : Integer.MAX_VALUE;
    }
}

