/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.service.protocol.handler;

import org.apache.directory.mitosis.configuration.ReplicationConfiguration;
import org.apache.directory.mitosis.service.DefaultReplicationContext;
import org.apache.directory.mitosis.service.ReplicationContext;
import org.apache.directory.mitosis.service.ReplicationInterceptor;
import org.apache.directory.mitosis.service.protocol.handler.ReplicationContextHandler;
import org.apache.directory.server.core.DirectoryService;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;

public class ReplicationProtocolHandler
implements IoHandler {
    private static final String CONTEXT = "context";
    private final ReplicationInterceptor interceptor;
    private final ReplicationConfiguration configuration;
    private final DirectoryService directoryService;
    private final ReplicationContextHandler contextHandler;

    public ReplicationProtocolHandler(ReplicationInterceptor interceptor, ReplicationContextHandler contextHandler) {
        assert (interceptor != null);
        assert (contextHandler != null);
        this.interceptor = interceptor;
        this.configuration = interceptor.getConfiguration();
        this.directoryService = interceptor.getDirectoryService();
        this.contextHandler = contextHandler;
    }

    public ReplicationContext getContext(IoSession session) {
        return (ReplicationContext)session.getAttribute(CONTEXT);
    }

    public ReplicationContextHandler getContextHandler() {
        return this.contextHandler;
    }

    public void sessionCreated(IoSession session) throws Exception {
        session.setAttribute(CONTEXT, (Object)new DefaultReplicationContext(this.interceptor, this.directoryService, this.configuration, session));
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.contextHandler.exceptionCaught(this.getContext(session), cause);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        this.contextHandler.messageReceived(this.getContext(session), message);
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        this.contextHandler.messageSent(this.getContext(session), message);
    }

    public void sessionClosed(IoSession session) throws Exception {
        ReplicationContext ctx = this.getContext(session);
        this.contextHandler.contextEnd(ctx);
        ctx.cancelAllExpirations();
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        this.contextHandler.contextIdle(this.getContext(session), status);
    }

    public void sessionOpened(IoSession session) throws Exception {
        this.contextHandler.contextBegin(this.getContext(session));
    }
}

