/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.service.protocol.handler;

import java.net.InetSocketAddress;
import java.util.Map;
import javax.naming.directory.SearchControls;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.common.CSNVector;
import org.apache.directory.mitosis.common.DefaultCSN;
import org.apache.directory.mitosis.common.Replica;
import org.apache.directory.mitosis.operation.AddEntryOperation;
import org.apache.directory.mitosis.operation.Operation;
import org.apache.directory.mitosis.service.ReplicationContext;
import org.apache.directory.mitosis.service.protocol.handler.ReplicationContextHandler;
import org.apache.directory.mitosis.service.protocol.message.BaseMessage;
import org.apache.directory.mitosis.service.protocol.message.BeginLogEntriesAckMessage;
import org.apache.directory.mitosis.service.protocol.message.BeginLogEntriesMessage;
import org.apache.directory.mitosis.service.protocol.message.EndLogEntriesAckMessage;
import org.apache.directory.mitosis.service.protocol.message.EndLogEntriesMessage;
import org.apache.directory.mitosis.service.protocol.message.LogEntryAckMessage;
import org.apache.directory.mitosis.service.protocol.message.LogEntryMessage;
import org.apache.directory.mitosis.service.protocol.message.LoginAckMessage;
import org.apache.directory.mitosis.service.protocol.message.LoginMessage;
import org.apache.directory.mitosis.store.ReplicationLogIterator;
import org.apache.directory.mitosis.store.ReplicationStore;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.util.SessionLog;

public class ReplicationClientContextHandler
implements ReplicationContextHandler {
    public void contextBegin(ReplicationContext ctx) throws Exception {
        LoginMessage m = new LoginMessage(ctx.getNextSequence(), ctx.getService().getConfiguration().getReplicaId());
        this.writeTimeLimitedMessage(ctx, m);
        ctx.getSession().setWriteTimeout(ctx.getConfiguration().getResponseTimeout());
        ctx.getSession().setIdleTime(IdleStatus.BOTH_IDLE, ctx.getConfiguration().getReplicationInterval());
    }

    public void contextEnd(ReplicationContext ctx) throws Exception {
    }

    public void messageReceived(ReplicationContext ctx, Object message) throws Exception {
        ctx.cancelExpiration(((BaseMessage)message).getSequence());
        if (ctx.getState() == ReplicationContext.State.READY) {
            if (message instanceof LogEntryAckMessage) {
                this.onLogEntryAck(ctx, (LogEntryAckMessage)message);
            } else if (message instanceof BeginLogEntriesAckMessage) {
                this.onBeginLogEntriesAck(ctx.getDirectoryService().getRegistries(), ctx, (BeginLogEntriesAckMessage)message);
            } else if (!(message instanceof EndLogEntriesAckMessage)) {
                this.onUnexpectedMessage(ctx, message);
            }
        } else if (message instanceof LoginAckMessage) {
            this.onLoginAck(ctx, (LoginAckMessage)message);
        } else {
            this.onUnexpectedMessage(ctx, message);
        }
    }

    public void messageSent(ReplicationContext ctx, Object message) throws Exception {
    }

    public WriteFuture writeTimeLimitedMessage(ReplicationContext ctx, Object message) {
        ctx.scheduleExpiration(message);
        return ctx.getSession().write(message);
    }

    public void exceptionCaught(ReplicationContext ctx, Throwable cause) throws Exception {
        if (SessionLog.isWarnEnabled((IoSession)ctx.getSession())) {
            SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Unexpected exception."), (Throwable)cause);
        }
        ctx.getSession().close();
    }

    public void contextIdle(ReplicationContext ctx, IdleStatus status) throws Exception {
        this.beginReplication(ctx);
    }

    private void onLoginAck(ReplicationContext ctx, LoginAckMessage message) {
        if (message.getResponseCode() != 0) {
            SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Login attempt failed: " + message.getResponseCode()));
            ctx.getSession().close();
            return;
        }
        for (Replica replica : ctx.getConfiguration().getPeerReplicas()) {
            if (!replica.getId().equals(message.getReplicaId())) continue;
            if (replica.getAddress().getAddress().equals(((InetSocketAddress)ctx.getSession().getRemoteAddress()).getAddress())) {
                ctx.setPeer(replica);
                ctx.setState(ReplicationContext.State.READY);
                return;
            }
            SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Peer address mismatches: " + ctx.getSession().getRemoteAddress() + " (expected: " + replica.getAddress()));
            ctx.getSession().close();
            return;
        }
        SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Unknown peer replica ID: " + message.getReplicaId()));
        ctx.getSession().close();
    }

    public boolean beginReplication(ReplicationContext ctx) {
        if (ctx.getState() == ReplicationContext.State.READY && ctx.getScheduledExpirations() <= 0 && ctx.getSession().getScheduledWriteRequests() <= 0) {
            if (SessionLog.isDebugEnabled((IoSession)ctx.getSession())) {
                SessionLog.debug((IoSession)ctx.getSession(), (String)("(" + ctx.getConfiguration().getReplicaId() + "->" + (ctx.getPeer() != null ? ctx.getPeer().getId() : "null") + ") Beginning replication. "));
            }
            ctx.getSession().write((Object)new BeginLogEntriesMessage(ctx.getNextSequence()));
            return true;
        }
        if (SessionLog.isDebugEnabled((IoSession)ctx.getSession())) {
            SessionLog.debug((IoSession)ctx.getSession(), (String)("(" + ctx.getConfiguration().getReplicaId() + "->" + (ctx.getPeer() != null ? ctx.getPeer().getId() : "null") + ") Couldn't begin replication.  State:" + (Object)((Object)ctx.getState()) + ", scheduledExpirations:" + ctx.getScheduledExpirations() + ", scheduledWriteRequests:" + ctx.getSession().getScheduledWriteRequests()));
        }
        return false;
    }

    private void onLogEntryAck(ReplicationContext ctx, LogEntryAckMessage message) throws Exception {
        if (message.getResponseCode() != 0) {
            SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Remote peer failed to execute a log entry."));
            ctx.getSession().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBeginLogEntriesAck(Registries registries, ReplicationContext ctx, BeginLogEntriesAckMessage message) throws Exception {
        CSNVector myPV;
        if (message.getResponseCode() != 0) {
            return;
        }
        ReplicationStore store = ctx.getConfiguration().getStore();
        CSNVector yourUV = message.getUpdateVector();
        try {
            myPV = store.getPurgeVector();
        }
        catch (Exception e) {
            SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Failed to get update vector."), (Throwable)e);
            ctx.getSession().close();
            return;
        }
        try {
            if (myPV.size() > 0 && yourUV.size() == 0) {
                SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Starting a whole DIT transfer."));
                this.sendAllEntries(ctx);
            } else {
                SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Starting a partial replication log transfer."));
                this.sendReplicationLogs(registries, ctx, myPV, yourUV);
            }
        }
        finally {
            ctx.getSession().write((Object)new EndLogEntriesMessage(ctx.getNextSequence()));
        }
    }

    private void sendAllEntries(ReplicationContext ctx) throws Exception {
        ClonedServerEntry rootDSE = ctx.getDirectoryService().getPartitionNexus().getRootDSE(null);
        EntryAttribute namingContextsAttr = rootDSE.get("namingContexts");
        if (namingContextsAttr == null || namingContextsAttr.size() == 0) {
            SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] No namingContexts attributes in rootDSE."));
            return;
        }
        for (Value namingContext : namingContextsAttr) {
            LdapDN contextName = new LdapDN((String)namingContext.get());
            SessionLog.info((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Sending entries under '" + contextName + '\''));
            Map mapping = ctx.getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping();
            contextName.normalize(mapping);
            this.sendAllEntries(ctx, contextName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllEntries(ReplicationContext ctx, LdapDN contextName) throws Exception {
        SearchControls ctrl = new SearchControls();
        ctrl.setSearchScope(2);
        LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        adminDn.normalize(ctx.getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), ctx.getDirectoryService());
        EntryFilteringCursor cursor = ctx.getDirectoryService().getPartitionNexus().search(new SearchOperationContext((CoreSession)adminSession, contextName, AliasDerefMode.DEREF_ALWAYS, (ExprNode)new PresenceNode("2.5.4.0"), ctrl));
        try {
            while (cursor.next()) {
                DefaultCSN csn;
                ServerEntry entry = (ServerEntry)cursor.get();
                EntryAttribute entryCSNAttr = entry.get("entryCSN");
                if (entryCSNAttr == null) continue;
                try {
                    Value val = entryCSNAttr.get();
                    csn = val instanceof byte[] ? new DefaultCSN(StringTools.utf8ToString((byte[])((byte[])val))) : new DefaultCSN((String)val);
                }
                catch (IllegalArgumentException ex) {
                    SessionLog.warn((IoSession)ctx.getSession(), (String)("An entry with improper entryCSN: " + entry.getDn()));
                    continue;
                }
                LdapDN dn = entry.getDn();
                dn.normalize(ctx.getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
                AddEntryOperation op = new AddEntryOperation(ctx.getDirectoryService().getRegistries(), csn, entry);
                this.writeTimeLimitedMessage(ctx, new LogEntryMessage(ctx.getNextSequence(), op));
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReplicationLogs(Registries registries, ReplicationContext ctx, CSNVector myPV, CSNVector yourUV) {
        for (String replicaId : myPV.getReplicaIds()) {
            CSN myCSN = myPV.getCSN(replicaId);
            CSN yourCSN = yourUV.getCSN(replicaId);
            if (yourCSN == null || myCSN != null && yourCSN.compareTo(myCSN) >= 0) continue;
            SessionLog.warn((IoSession)ctx.getSession(), (String)("Remote update vector (" + yourUV + ") is out-of-date.  Full replication is required."));
            ctx.getSession().close();
            return;
        }
        ReplicationLogIterator logIt = ctx.getConfiguration().getStore().getLogs(yourUV, false);
        try {
            while (logIt.next()) {
                Operation op = logIt.getOperation(registries);
                this.writeTimeLimitedMessage(ctx, new LogEntryMessage(ctx.getNextSequence(), op));
            }
        }
        finally {
            logIt.close();
        }
    }

    private void onUnexpectedMessage(ReplicationContext ctx, Object message) {
        SessionLog.warn((IoSession)ctx.getSession(), (String)("Unexpected message: " + message));
        ctx.getSession().close();
    }
}

