/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.service.protocol.codec;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.common.CSNVector;
import org.apache.directory.mitosis.service.protocol.codec.ResponseMessageEncoder;
import org.apache.directory.mitosis.service.protocol.message.BaseMessage;
import org.apache.directory.mitosis.service.protocol.message.BeginLogEntriesAckMessage;
import org.apache.mina.common.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeginLogEntriesAckMessageEncoder
extends ResponseMessageEncoder {
    private final CharsetEncoder utf8encoder = Charset.forName("UTF-8").newEncoder();

    @Override
    protected void encodeBody(BaseMessage in, ByteBuffer out) throws Exception {
        super.encodeBody(in, out);
        BeginLogEntriesAckMessage m = (BeginLogEntriesAckMessage)in;
        if (m.getResponseCode() != 0) {
            return;
        }
        this.writeCSNVector(out, m.getPurgeVector());
        this.writeCSNVector(out, m.getUpdateVector());
    }

    private void writeCSNVector(ByteBuffer out, CSNVector csns) {
        Set<String> replicaIds = csns.getReplicaIds();
        int nReplicas = replicaIds.size();
        out.putInt(nReplicas);
        for (String replicaId : replicaIds) {
            CSN csn = csns.getCSN(replicaId);
            try {
                out.putString((CharSequence)replicaId, this.utf8encoder);
                out.put((byte)0);
                out.putLong(csn.getTimestamp());
                out.putInt(csn.getOperationSequence());
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Set<Class<?>> getMessageTypes() {
        HashSet set = new HashSet();
        set.add(BeginLogEntriesAckMessage.class);
        return set;
    }
}

