/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.service.protocol.codec;

import org.apache.directory.mitosis.service.protocol.message.BaseMessage;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoder;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;

public abstract class BaseMessageDecoder
implements MessageDecoder {
    private final int type;
    private final int minBodyLength;
    private final int maxBodyLength;
    private boolean readHeader;
    private int sequence;
    private int bodyLength;

    protected BaseMessageDecoder(int type, int minBodyLength, int maxBodyLength) {
        this.type = type;
        this.minBodyLength = minBodyLength;
        this.maxBodyLength = maxBodyLength;
    }

    public final MessageDecoderResult decodable(IoSession session, ByteBuffer buf) {
        return this.type == buf.get() ? OK : NOT_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageDecoderResult decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (!this.readHeader) {
            if (in.remaining() < 9) {
                return NEED_DATA;
            }
            in.get();
            this.sequence = in.getInt();
            this.bodyLength = in.getInt();
            if (this.bodyLength < this.minBodyLength || this.bodyLength > this.maxBodyLength) {
                throw new ProtocolDecoderException("Wrong bodyLength: " + this.bodyLength);
            }
            this.readHeader = true;
        }
        if (this.readHeader) {
            if (in.remaining() < this.bodyLength) {
                return NEED_DATA;
            }
            int oldLimit = in.limit();
            try {
                in.limit(in.position() + this.bodyLength);
                Registries registries = (Registries)session.getAttribute("registries");
                out.write((Object)this.decodeBody(registries, this.sequence, this.bodyLength, in));
                MessageDecoderResult messageDecoderResult = OK;
                return messageDecoderResult;
            }
            finally {
                this.readHeader = false;
                in.limit(oldLimit);
            }
        }
        throw new InternalError();
    }

    protected abstract BaseMessage decodeBody(Registries var1, int var2, int var3, ByteBuffer var4) throws Exception;
}

