/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.service;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.ParseException;
import java.util.ArrayList;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.directory.mitosis.common.Constants;
import org.apache.directory.mitosis.common.DefaultCSN;
import org.apache.directory.mitosis.configuration.ReplicationConfiguration;
import org.apache.directory.mitosis.operation.Operation;
import org.apache.directory.mitosis.operation.OperationFactory;
import org.apache.directory.mitosis.service.ClientConnectionManager;
import org.apache.directory.mitosis.service.ReplicationServiceException;
import org.apache.directory.mitosis.service.protocol.codec.ReplicationServerProtocolCodecFactory;
import org.apache.directory.mitosis.service.protocol.handler.ReplicationServerProtocolHandler;
import org.apache.directory.mitosis.store.ReplicationStore;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationInterceptor.class);
    public static final String DEFAULT_SERVICE_NAME = "replicationService";
    private static final String ENTRY_CSN_OID = "1.3.6.1.4.1.18060.0.4.1.2.30";
    private static final String ENTRY_DELETED_OID = "1.3.6.1.4.1.18060.0.4.1.2.31";
    private String name = "replicationService";
    private DirectoryService directoryService;
    private ReplicationConfiguration configuration;
    private PartitionNexus nexus;
    private OperationFactory operationFactory;
    private ReplicationStore store;
    private IoAcceptor registry;
    private final ClientConnectionManager clientConnectionManager = new ClientConnectionManager(this);
    private Registries registries;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReplicationConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ReplicationConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init(DirectoryService directoryService) throws Exception {
        this.configuration.validate();
        this.directoryService = directoryService;
        this.registries = directoryService.getRegistries();
        this.nexus = directoryService.getPartitionNexus();
        this.store = this.configuration.getStore();
        this.operationFactory = new OperationFactory(directoryService, this.configuration);
        this.store.open(directoryService, this.configuration);
        boolean serviceStarted = false;
        try {
            this.startNetworking();
            serviceStarted = true;
        }
        catch (Exception e) {
            throw new ReplicationServiceException("Failed to initialize MINA ServiceRegistry.", e);
        }
        finally {
            if (!serviceStarted) {
                this.store.close();
            }
        }
        this.purgeAgedData();
    }

    private void startNetworking() throws Exception {
        this.registry = new SocketAcceptor();
        SocketAcceptorConfig config = new SocketAcceptorConfig();
        config.setReuseAddress(true);
        config.getFilterChain().addLast("protocol", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ReplicationServerProtocolCodecFactory()));
        config.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        this.registry.bind((SocketAddress)new InetSocketAddress(this.configuration.getServerPort()), (IoHandler)new ReplicationServerProtocolHandler(this), (IoServiceConfig)config);
        this.clientConnectionManager.start(this.configuration);
    }

    public void destroy() {
        this.stopNetworking();
        this.store.close();
    }

    private void stopNetworking() {
        try {
            this.clientConnectionManager.stop();
        }
        catch (Exception e) {
            LOG.error("[Replica-{}] Failed to stop the client connection manager.", (Object)this.configuration.getReplicaId());
            LOG.error("Stop failure exception: ", (Throwable)e);
        }
        this.registry.unbindAll();
    }

    public void replicate() {
        LOG.info("[Replica-{}] Forcing replication...", (Object)this.configuration.getReplicaId());
        this.clientConnectionManager.replicate();
    }

    public void interruptConnectors() {
        LOG.info("[Replica-{}] Waking sleeping replicas...", (Object)this.configuration.getReplicaId());
        this.clientConnectionManager.interruptConnectors();
    }

    public void purgeAgedData() throws Exception {
        ExprNode filter;
        ClonedServerEntry rootDSE = this.nexus.getRootDSE(null);
        EntryAttribute namingContextsAttr = rootDSE.get("namingContexts");
        if (namingContextsAttr == null || namingContextsAttr.size() == 0) {
            throw new NamingException("No namingContexts attributes in rootDSE.");
        }
        DefaultCSN purgeCSN = new DefaultCSN(System.currentTimeMillis() - (long)this.configuration.getLogMaxAge() * 1000L * 60L * 60L * 24L, "ZZZZZZZZZZZZZZZZ", Integer.MAX_VALUE);
        try {
            filter = FilterParser.parse((String)("(&(1.3.6.1.4.1.18060.0.4.1.2.30<=" + purgeCSN.toOctetString() + ")(" + ENTRY_DELETED_OID + "=TRUE))"));
        }
        catch (ParseException e) {
            throw (NamingException)new NamingException().initCause(e);
        }
        for (Value namingContext : namingContextsAttr) {
            LdapDN contextName = new LdapDN((String)namingContext.get());
            contextName.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
            LOG.info("[Replica-{}] Purging aged data under '{}'", (Object)this.configuration.getReplicaId(), (Object)contextName);
            this.purgeAgedData(contextName, filter);
        }
        this.store.removeLogs(purgeCSN, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeAgedData(LdapDN contextName, ExprNode filter) throws Exception {
        SearchControls ctrl = new SearchControls();
        ctrl.setSearchScope(2);
        ctrl.setReturningAttributes(new String[]{"entryCSN", "entryDeleted"});
        LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        adminDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), this.directoryService);
        EntryFilteringCursor cursor = this.nexus.search(new SearchOperationContext((CoreSession)adminSession, contextName, AliasDerefMode.DEREF_ALWAYS, filter, ctrl));
        ArrayList<LdapDN> names = new ArrayList<LdapDN>();
        try {
            while (cursor.next()) {
                ServerEntry entry = (ServerEntry)cursor.get();
                LdapDN name = entry.getDn();
                if (name.size() <= contextName.size()) continue;
                names.add(name);
            }
        }
        finally {
            cursor.close();
        }
        for (LdapDN name : names) {
            try {
                name.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
                ClonedServerEntry entry = this.nexus.lookup(new LookupOperationContext((CoreSession)adminSession, name));
                LOG.info("[Replica-{}] Purge: " + name + " (" + entry + ')', (Object)this.configuration.getReplicaId());
                this.nexus.delete(new DeleteOperationContext((CoreSession)adminSession, name));
            }
            catch (NamingException ex) {
                LOG.error("[Replica-{}] Failed to fetch/delete: " + name, (Object)this.configuration.getReplicaId(), (Object)ex);
            }
        }
    }

    public void add(NextInterceptor nextInterceptor, AddOperationContext addContext) throws Exception {
        Operation op = this.operationFactory.newAdd(addContext.getDn(), (ServerEntry)addContext.getEntry());
        op.execute(this.nexus, this.store, addContext.getSession());
    }

    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws Exception {
        Operation op = this.operationFactory.newDelete(deleteContext.getDn());
        op.execute(this.nexus, this.store, deleteContext.getSession());
    }

    public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws Exception {
        Operation op = this.operationFactory.newModify(modifyContext);
        op.execute(this.nexus, this.store, modifyContext.getSession());
    }

    public void move(NextInterceptor next, MoveOperationContext moveOpContext) throws Exception {
        Operation op = this.operationFactory.newMove(moveOpContext.getDn(), moveOpContext.getParent());
        op.execute(this.nexus, this.store, moveOpContext.getSession());
    }

    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameOpContext) throws Exception {
        Operation op = this.operationFactory.newMove(moveAndRenameOpContext.getDn(), moveAndRenameOpContext.getParent(), moveAndRenameOpContext.getNewRdn(), moveAndRenameOpContext.getDelOldDn());
        op.execute(this.nexus, this.store, moveAndRenameOpContext.getSession());
    }

    public void rename(NextInterceptor next, RenameOperationContext renameOpContext) throws Exception {
        Operation op = this.operationFactory.newModifyRn(renameOpContext.getDn(), renameOpContext.getNewRdn(), renameOpContext.getDelOldDn());
        op.execute(this.nexus, this.store, renameOpContext.getSession());
    }

    public boolean hasEntry(NextInterceptor nextInterceptor, EntryOperationContext entryContext) throws Exception {
        boolean hasEntry = nextInterceptor.hasEntry(entryContext);
        if (hasEntry) {
            try {
                ClonedServerEntry entry = nextInterceptor.lookup(new LookupOperationContext(entryContext.getSession(), entryContext.getDn()));
                hasEntry = !this.isDeleted((ServerEntry)entry);
            }
            catch (NameNotFoundException e) {
                hasEntry = false;
            }
        }
        return hasEntry;
    }

    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext lookupContext) throws Exception {
        if (lookupContext.getAttrsId() != null) {
            String[] attrIds;
            boolean found = false;
            for (String attrId : attrIds = lookupContext.getAttrsIdArray()) {
                if (!"entryDeleted".equals(attrId)) continue;
                found = true;
                break;
            }
            if (!found) {
                String[] newAttrIds = new String[attrIds.length + 1];
                System.arraycopy(attrIds, 0, newAttrIds, 0, attrIds.length);
                newAttrIds[attrIds.length] = "entryDeleted";
                lookupContext.setAttrsId(newAttrIds);
            }
        }
        ClonedServerEntry entry = nextInterceptor.lookup(lookupContext);
        this.ensureNotDeleted((OperationContext)lookupContext, (ServerEntry)entry);
        return entry;
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.search(new SearchOperationContext(opContext.getSession(), opContext.getDn(), opContext.getAliasDerefMode(), (ExprNode)new PresenceNode("2.5.4.0"), new SearchControls()));
        cursor.addEntryFilter(Constants.DELETED_ENTRIES_FILTER);
        return cursor;
    }

    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        SearchControls searchControls = opContext.getSearchControls();
        if (searchControls.getReturningAttributes() != null) {
            String[] oldAttrIds = searchControls.getReturningAttributes();
            String[] newAttrIds = new String[oldAttrIds.length + 1];
            System.arraycopy(oldAttrIds, 0, newAttrIds, 0, oldAttrIds.length);
            newAttrIds[oldAttrIds.length] = "entryDeleted".toLowerCase();
            searchControls.setReturningAttributes(newAttrIds);
        }
        EntryFilteringCursor cursor = nextInterceptor.search(new SearchOperationContext(opContext.getSession(), opContext.getDn(), opContext.getAliasDerefMode(), opContext.getFilter(), searchControls));
        cursor.addEntryFilter(Constants.DELETED_ENTRIES_FILTER);
        return cursor;
    }

    private void ensureNotDeleted(OperationContext opContext, ServerEntry entry) throws Exception {
        if (this.isDeleted(entry)) {
            LdapNameNotFoundException e = new LdapNameNotFoundException("Deleted entry: " + opContext.getDn().getUpName());
            e.setResolvedName((Name)this.nexus.getMatchedName(new GetMatchedNameOperationContext(opContext.getSession(), opContext.getDn())));
            throw e;
        }
    }

    private boolean isDeleted(ServerEntry entry) throws NamingException {
        if (entry == null) {
            return true;
        }
        return entry.contains("entryDeleted", new String[]{"TRUE"});
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }
}

