/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.service;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.directory.mitosis.common.Replica;
import org.apache.directory.mitosis.configuration.ReplicationConfiguration;
import org.apache.directory.mitosis.service.ReplicationInterceptor;
import org.apache.directory.mitosis.service.protocol.codec.ReplicationClientProtocolCodecFactory;
import org.apache.directory.mitosis.service.protocol.handler.ReplicationClientProtocolHandler;
import org.apache.directory.mitosis.service.protocol.handler.ReplicationProtocolHandler;
import org.apache.mina.common.ExecutorThreadModel;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ClientConnectionManager.class);
    private final ReplicationInterceptor interceptor;
    private final IoConnector connector = new SocketConnector();
    private final IoConnectorConfig connectorConfig = new SocketConnectorConfig();
    private final Map<String, Connection> sessions = new HashMap<String, Connection>();
    private ReplicationConfiguration configuration;
    private ConnectionMonitor monitor;

    ClientConnectionManager(ReplicationInterceptor interceptor) {
        this.interceptor = interceptor;
        ExecutorThreadModel threadModel = ExecutorThreadModel.getInstance((String)"mitosis");
        threadModel.setExecutor((Executor)new ThreadPoolExecutor(16, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
        this.connectorConfig.setThreadModel((ThreadModel)threadModel);
        this.connectorConfig.getFilterChain().addLast("protocol", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ReplicationClientProtocolCodecFactory()));
        this.connectorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
    }

    public void start(ReplicationConfiguration cfg) throws Exception {
        this.configuration = cfg;
        this.monitor = new ConnectionMonitor();
        this.monitor.start();
    }

    public void stop() throws Exception {
        this.monitor.shutdown();
        this.connector.getFilterChain().clear();
        ((ExecutorService)((ExecutorThreadModel)this.connectorConfig.getThreadModel()).getExecutor()).shutdown();
        this.sessions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate() {
        Iterator<Connection> i$ = this.sessions.values().iterator();
        while (i$.hasNext()) {
            Connection connection;
            Connection connection2 = connection = i$.next();
            synchronized (connection2) {
                if (connection.session != null) {
                    ((ReplicationProtocolHandler)connection.session.getHandler()).getContext(connection.session).replicate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptConnectors() {
        Iterator<Connection> i$ = this.sessions.values().iterator();
        while (i$.hasNext()) {
            Connection connection;
            Connection connection2 = connection = i$.next();
            synchronized (connection2) {
                if (connection.inProgress && connection.connector != null) {
                    connection.connector.interrupt();
                }
            }
        }
    }

    private static class Connection {
        private IoSession session;
        private int delay = -1;
        private boolean inProgress;
        private Connector connector;
        private String replicaId;
    }

    private class Connector
    extends Thread {
        private final Replica replica;
        private final Connection con;

        public Connector(Replica replica, Connection con) {
            super("ClientConnectionManager-" + replica);
            this.replica = replica;
            this.con = con;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.con.delay > 0) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("[Replica-{}] Waiting for {} seconds to reconnect to replica-" + this.con.replicaId, (Object)ClientConnectionManager.this.configuration.getReplicaId(), (Object)this.con.delay);
                }
                try {
                    Thread.sleep((long)this.con.delay * 1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            LOG.info("[Replica-{}] Connecting to replica-{}", (Object)ClientConnectionManager.this.configuration.getReplicaId(), (Object)this.replica.getId());
            try {
                ClientConnectionManager.this.connectorConfig.setConnectTimeout(ClientConnectionManager.this.configuration.getResponseTimeout());
                Object future = ClientConnectionManager.this.connector.connect((SocketAddress)this.replica.getAddress(), (IoHandler)new ReplicationClientProtocolHandler(ClientConnectionManager.this.interceptor), (IoServiceConfig)ClientConnectionManager.this.connectorConfig);
                future.join();
                IoSession session = future.getSession();
                Connection connection = this.con;
                synchronized (connection) {
                    this.con.session = session;
                    this.con.delay = -1;
                    this.con.inProgress = false;
                    this.con.replicaId = this.replica.getId();
                }
            }
            catch (RuntimeIOException e) {
                LOG.warn("[Replica-" + ClientConnectionManager.this.configuration.getReplicaId() + "] Failed to connect to replica-" + this.replica.getId(), (Throwable)e);
            }
            finally {
                Connection connection = this.con;
                synchronized (connection) {
                    this.con.inProgress = false;
                    this.con.connector = null;
                }
            }
        }
    }

    private class ConnectionMonitor
    extends Thread {
        private boolean timeToShutdown;

        public ConnectionMonitor() {
            super("ClientConnectionManager");
            for (Replica replica : ClientConnectionManager.this.configuration.getPeerReplicas()) {
                Connection con = (Connection)ClientConnectionManager.this.sessions.get(replica.getId());
                if (con != null) continue;
                con = new Connection();
                con.replicaId = replica.getId();
                ClientConnectionManager.this.sessions.put(replica.getId(), con);
            }
        }

        public void shutdown() {
            this.timeToShutdown = true;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    LOG.warn("[Replica-{}] Unexpected exception.", (Object)ClientConnectionManager.this.configuration.getReplicaId(), (Object)e);
                }
            }
        }

        public void run() {
            while (!this.timeToShutdown) {
                this.connectUnconnected();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.warn("[Replica-{}] Unexpected exception.", (Object)ClientConnectionManager.this.configuration.getReplicaId(), (Object)e);
                }
            }
            this.disconnectConnected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connectUnconnected() {
            for (Replica replica : ClientConnectionManager.this.configuration.getPeerReplicas()) {
                Connection con = (Connection)ClientConnectionManager.this.sessions.get(replica.getId());
                if (con == null) {
                    con = new Connection();
                    con.replicaId = replica.getId();
                    ClientConnectionManager.this.sessions.put(replica.getId(), con);
                }
                Connection connection = con;
                synchronized (connection) {
                    if (con.inProgress) {
                        continue;
                    }
                    if (con.session != null) {
                        if (con.session.isConnected()) {
                            continue;
                        }
                        con.session = null;
                    }
                    con.inProgress = true;
                    if (con.delay < 0) {
                        con.delay = 0;
                    } else if (con.delay == 0) {
                        con.delay = 2;
                    } else {
                        con.delay *= 2;
                        if (con.delay > 60) {
                            con.delay = 60;
                        }
                    }
                }
                Connector connector = new Connector(replica, con);
                Connection connection2 = con;
                synchronized (connection2) {
                    con.connector = connector;
                }
                connector.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void disconnectConnected() {
            LOG.info("[Replica-{}] Closing all connections...", (Object)ClientConnectionManager.this.configuration.getReplicaId());
            while (true) {
                Iterator connections = ClientConnectionManager.this.sessions.values().iterator();
                while (connections.hasNext()) {
                    Connection con;
                    Connection connection = con = (Connection)connections.next();
                    synchronized (connection) {
                        if (con.inProgress) {
                            if (con.connector != null) {
                                con.connector.interrupt();
                            }
                            continue;
                        }
                        connections.remove();
                        if (con.session != null) {
                            LOG.info("[Replica-{}] Closed connection to Replica-{}", (Object)ClientConnectionManager.this.configuration.getReplicaId(), (Object)con.replicaId);
                            con.session.close();
                        }
                    }
                }
                if (ClientConnectionManager.this.sessions.isEmpty()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

