/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.operation;

import java.util.List;
import java.util.UUID;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.common.CSNFactory;
import org.apache.directory.mitosis.configuration.ReplicationConfiguration;
import org.apache.directory.mitosis.operation.AddAttributeOperation;
import org.apache.directory.mitosis.operation.AddEntryOperation;
import org.apache.directory.mitosis.operation.CompositeOperation;
import org.apache.directory.mitosis.operation.DeleteAttributeOperation;
import org.apache.directory.mitosis.operation.Operation;
import org.apache.directory.mitosis.operation.ReplaceAttributeOperation;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;

public class OperationFactory {
    private final String replicaId;
    private final PartitionNexus nexus;
    private final CSNFactory csnFactory;
    private final AttributeTypeRegistry attributeRegistry;
    private Registries registries;
    private DirectoryService ds;

    public OperationFactory(DirectoryService directoryService, ReplicationConfiguration cfg) {
        this.replicaId = cfg.getReplicaId();
        this.nexus = directoryService.getPartitionNexus();
        this.csnFactory = cfg.getCsnFactory();
        this.registries = directoryService.getRegistries();
        this.attributeRegistry = this.registries.getAttributeTypeRegistry();
        this.ds = directoryService;
    }

    public Operation newAdd(LdapDN normalizedName, ServerEntry entry) throws Exception {
        return this.newAdd(this.newCSN(), normalizedName, entry);
    }

    private Operation newAdd(CSN csn, LdapDN normalizedName, ServerEntry entry) throws Exception {
        this.checkBeforeAdd(normalizedName);
        ServerEntry cloneEntry = (ServerEntry)entry.clone();
        cloneEntry.removeAttributes(new String[]{"entryUUID"});
        cloneEntry.removeAttributes(new String[]{"entryDeleted"});
        cloneEntry.put("entryUUID", new String[]{UUID.randomUUID().toString()});
        cloneEntry.put("entryDeleted", new String[]{"FALSE"});
        cloneEntry.put("entryCSN", new String[]{csn.toOctetString()});
        return new AddEntryOperation(this.registries, csn, cloneEntry);
    }

    public Operation newDelete(LdapDN normalizedName) throws NamingException {
        CSN csn = this.newCSN();
        CompositeOperation result = new CompositeOperation(this.registries, csn);
        result.add(new ReplaceAttributeOperation(this.registries, csn, normalizedName, (ServerAttribute)new DefaultServerAttribute("entryDeleted", this.attributeRegistry.lookup("entryDeleted"), new String[]{"TRUE"})));
        return this.addDefaultOperations(result, csn, normalizedName);
    }

    public Operation newModify(ModifyOperationContext opContext) throws NamingException {
        List items = opContext.getModItems();
        LdapDN normalizedName = opContext.getDn();
        CSN csn = this.newCSN();
        CompositeOperation result = new CompositeOperation(this.registries, csn);
        for (Modification item : items) {
            result.add(this.newModify(csn, normalizedName, item.getOperation(), (ServerAttribute)item.getAttribute()));
        }
        result.add(new ReplaceAttributeOperation(this.registries, csn, normalizedName, (ServerAttribute)new DefaultServerAttribute("entryDeleted", this.attributeRegistry.lookup("entryDeleted"), new String[]{"FALSE"})));
        return this.addDefaultOperations(result, csn, normalizedName);
    }

    private Operation newModify(CSN csn, LdapDN normalizedName, ModificationOperation modOp, ServerAttribute attribute) {
        switch (modOp) {
            case ADD_ATTRIBUTE: {
                return new AddAttributeOperation(this.registries, csn, normalizedName, (EntryAttribute)attribute);
            }
            case REPLACE_ATTRIBUTE: {
                return new ReplaceAttributeOperation(this.registries, csn, normalizedName, attribute);
            }
            case REMOVE_ATTRIBUTE: {
                return new DeleteAttributeOperation(this.registries, csn, normalizedName, attribute);
            }
        }
        throw new IllegalArgumentException("Unknown modOp: " + modOp);
    }

    public Operation newModifyRn(LdapDN oldName, Rdn newRdn, boolean deleteOldRn) throws Exception {
        LdapDN newParentName = (LdapDN)oldName.clone();
        newParentName.remove(oldName.size() - 1);
        return this.newMove(oldName, newParentName, newRdn, deleteOldRn);
    }

    public Operation newMove(LdapDN oldName, LdapDN newParentName) throws Exception {
        return this.newMove(oldName, newParentName, oldName.getRdn(), true);
    }

    public Operation newMove(LdapDN oldName, LdapDN newParentName, Rdn newRdn, boolean deleteOldRn) throws Exception {
        CSN csn = this.newCSN();
        CompositeOperation result = new CompositeOperation(this.registries, csn);
        SearchControls ctrl = new SearchControls();
        ctrl.setSearchScope(2);
        LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        adminDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), this.ds);
        EntryFilteringCursor cursor = this.nexus.search(new SearchOperationContext((CoreSession)adminSession, oldName, AliasDerefMode.DEREF_ALWAYS, (ExprNode)new PresenceNode("2.5.4.0"), ctrl));
        while (cursor.next()) {
            ServerEntry entry = (ServerEntry)cursor.get();
            LdapDN oldEntryName = entry.getDn();
            oldEntryName.normalize(this.attributeRegistry.getNormalizerMapping());
            result.add(new ReplaceAttributeOperation(this.registries, csn, oldEntryName, (ServerAttribute)new DefaultServerAttribute("entryDeleted", this.attributeRegistry.lookup("entryDeleted"), new String[]{"TRUE"})));
            if (oldEntryName.size() == oldName.size()) {
                boolean removed;
                String oldRDNAttributeID;
                EntryAttribute oldRDNAttribute;
                if (deleteOldRn && (oldRDNAttribute = entry.get(oldRDNAttributeID = oldName.getRdn().getUpType())) != null && (removed = oldRDNAttribute.remove(new String[]{(String)oldName.getRdn().getUpValue()})) && oldRDNAttribute.size() == 0) {
                    entry.removeAttributes(new String[]{oldRDNAttributeID});
                }
                String newRDNAttributeID = newRdn.getUpType();
                String newRDNAttributeValue = (String)newRdn.getUpValue();
                EntryAttribute newRDNAttribute = entry.get(newRDNAttributeID);
                if (newRDNAttribute != null) {
                    newRDNAttribute.add(new String[]{newRDNAttributeValue});
                } else {
                    entry.put(newRDNAttributeID, new String[]{newRDNAttributeValue});
                }
            }
            LdapDN newEntryName = (LdapDN)newParentName.clone();
            newEntryName.add(newRdn);
            for (int i = oldEntryName.size() - newEntryName.size(); i > 0; --i) {
                newEntryName.add(oldEntryName.get(oldEntryName.size() - i));
            }
            newEntryName.normalize(this.attributeRegistry.getNormalizerMapping());
            result.add(this.newAdd(csn, newEntryName, entry));
            this.addDefaultOperations(result, csn, oldEntryName);
        }
        return result;
    }

    private void checkBeforeAdd(LdapDN newEntryName) throws Exception {
        LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        adminDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), this.ds);
        if (this.nexus.hasEntry(new EntryOperationContext((CoreSession)adminSession, newEntryName))) {
            Value value;
            ClonedServerEntry entry = this.nexus.lookup(new LookupOperationContext((CoreSession)adminSession, newEntryName));
            EntryAttribute deleted = entry.get("entryDeleted");
            Value value2 = value = deleted == null ? null : deleted.get();
            if (value != null && "TRUE".equalsIgnoreCase(value.toString())) {
                return;
            }
            throw new NameAlreadyBoundException(newEntryName.toString() + " already exists.");
        }
    }

    private CompositeOperation addDefaultOperations(CompositeOperation result, CSN csn, LdapDN normalizedName) throws NamingException {
        result.add(new ReplaceAttributeOperation(this.registries, csn, normalizedName, (ServerAttribute)new DefaultServerAttribute("entryDeleted", this.attributeRegistry.lookup("entryCSN"), new String[]{csn.toOctetString()})));
        return result;
    }

    private CSN newCSN() {
        return this.csnFactory.newInstance(this.replicaId);
    }
}

