/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.operation;

import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.operation.Operation;
import org.apache.directory.mitosis.operation.OperationType;
import org.apache.directory.mitosis.operation.support.EntryUtil;
import org.apache.directory.mitosis.store.ReplicationStore;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.name.LdapDN;

public abstract class AttributeOperation
extends Operation {
    protected LdapDN dn;
    protected EntryAttribute attribute;

    AttributeOperation(Registries registries, OperationType operationType) {
        super(registries, operationType);
    }

    public AttributeOperation(Registries registries, OperationType operationType, CSN csn, LdapDN dn, EntryAttribute attribute) {
        super(registries, operationType, csn);
        assert (dn != null);
        assert (attribute != null);
        this.dn = dn;
        this.attribute = attribute.clone();
    }

    public LdapDN getDn() {
        return (LdapDN)this.dn.clone();
    }

    protected final void execute0(PartitionNexus nexus, ReplicationStore store, CoreSession coreSession) throws Exception {
        if (!EntryUtil.isEntryUpdatable(coreSession, this.dn, this.getCSN())) {
            return;
        }
        EntryUtil.createGlueEntries(coreSession, this.dn, true);
        this.execute1(nexus, coreSession);
    }

    protected abstract void execute1(PartitionNexus var1, CoreSession var2) throws Exception;

    public EntryAttribute getAttribute() {
        return this.attribute;
    }

    public String toString() {
        return super.toString() + ": [" + this.dn + ']';
    }
}

