/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.operation;

import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.operation.Operation;
import org.apache.directory.mitosis.operation.OperationType;
import org.apache.directory.mitosis.operation.support.EntryUtil;
import org.apache.directory.mitosis.store.ReplicationStore;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.name.LdapDN;

public class AddEntryOperation
extends Operation {
    private static final long serialVersionUID = 2294492811671880570L;
    private Entry entry;

    public AddEntryOperation(Registries registries) {
        super(registries, OperationType.ADD_ENTRY);
    }

    public AddEntryOperation(Registries registries, CSN csn, ServerEntry entry) {
        super(registries, OperationType.ADD_ENTRY, csn);
        assert (entry != null);
        this.entry = entry;
    }

    protected void execute0(PartitionNexus nexus, ReplicationStore store, CoreSession coreSession) throws Exception {
        if (!EntryUtil.isEntryUpdatable(coreSession, this.entry.getDn(), this.getCSN())) {
            return;
        }
        EntryUtil.createGlueEntries(coreSession, this.entry.getDn(), false);
        if (nexus.lookup(new LookupOperationContext(coreSession, this.entry.getDn())) != null) {
            this.recursiveDelete(nexus, this.entry.getDn(), coreSession);
        }
        nexus.add(new AddOperationContext(coreSession, (ServerEntry)this.entry));
    }

    private void recursiveDelete(PartitionNexus nexus, LdapDN normalizedName, CoreSession coreSession) throws Exception {
        EntryFilteringCursor cursor = nexus.list(new ListOperationContext(coreSession, normalizedName));
        if (!cursor.available()) {
            nexus.delete(new DeleteOperationContext(coreSession, normalizedName));
            return;
        }
        Registries registries = coreSession.getDirectoryService().getRegistries();
        while (cursor.next()) {
            ClonedServerEntry sr = (ClonedServerEntry)cursor.get();
            LdapDN dn = sr.getDn();
            dn.normalize(registries.getAttributeTypeRegistry().getNormalizerMapping());
            this.recursiveDelete(nexus, dn, coreSession);
        }
        nexus.delete(new DeleteOperationContext(coreSession, normalizedName));
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public String toString() {
        return super.toString() + ": [" + this.entry.getDn() + "].new( " + this.entry + " )";
    }
}

