/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.configuration;

import java.beans.PropertyEditorSupport;
import java.util.regex.Pattern;
import org.apache.directory.shared.ldap.util.StringTools;

public class ReplicaIdPropertyEditor
extends PropertyEditorSupport {
    private static final Pattern REPLICA_ID_PATTERN = Pattern.compile("[-_A-Z0-9]{1,16}");

    public ReplicaIdPropertyEditor() {
    }

    public ReplicaIdPropertyEditor(Object source) {
        super(source);
    }

    public static boolean check(String id) {
        if (StringTools.isEmpty((String)id)) {
            throw new IllegalArgumentException("Empty ID: " + id);
        }
        String tmpId = id.trim().toUpperCase();
        return REPLICA_ID_PATTERN.matcher(tmpId).matches();
    }

    public String getAsText() {
        Object val = this.getValue();
        if (val == null) {
            return "";
        }
        return val.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if ((text = text.trim()).length() == 0) {
            this.setValue(null);
        } else if (ReplicaIdPropertyEditor.check(text)) {
            this.setValue(text);
        } else {
            this.setValue(null);
        }
    }
}

