/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.shared.ldap.util.EqualsBuilder;
import org.apache.directory.shared.ldap.util.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSNVector {
    private static final long serialVersionUID = 1L;
    private final Map<String, CSN> csns = new HashMap<String, CSN>();

    public void setCSN(CSN csn) {
        this.csns.put(csn.getReplicaId(), csn);
    }

    public void setAllCSN(CSNVector vector) {
        Iterator<CSN> i = vector.csns.values().iterator();
        while (i.hasNext()) {
            this.setCSN(i.next());
        }
    }

    public CSN getCSN(String replicaId) {
        return this.csns.get(replicaId);
    }

    public CSN removeCSN(String replicaId) {
        return this.csns.remove(replicaId);
    }

    public Set<String> getReplicaIds() {
        return this.csns.keySet();
    }

    public int size() {
        return this.csns.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSNVector)) {
            return false;
        }
        CSNVector rhs = (CSNVector)object;
        return new EqualsBuilder().append(this.csns, rhs.csns).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-33446267, -459427867).append(this.csns).toHashCode();
    }

    public CSNVector clone() {
        CSNVector result = new CSNVector();
        result.csns.putAll(this.csns);
        return result;
    }

    public String toString() {
        return this.csns.toString();
    }
}

