/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.client.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.SchemaBinaryAttributeDetector;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.PoolableLdapConnectionFactory;
import org.apache.directory.server.ldap.LdapServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapApiIntegrationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LdapApiIntegrationUtils.class);
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_ADMIN = "uid=admin,ou=system";
    private static final String DEFAULT_PASSWORD = "secret";
    private static Map<Integer, LdapConnectionPool> pools = new HashMap<Integer, LdapConnectionPool>();

    public static LdapNetworkConnection createAdminConnection(LdapServer ldapServer) throws LdapException, IOException {
        LdapNetworkConnection conn = new LdapNetworkConnection(DEFAULT_HOST, ldapServer.getPort());
        conn.bind(DEFAULT_ADMIN, DEFAULT_PASSWORD);
        return conn;
    }

    public static void closeConnection(LdapNetworkConnection conn) throws LdapException, IOException {
        if (conn != null) {
            conn.unBind();
            conn.close();
        }
    }

    public static LdapConnection getPooledAdminConnection(LdapServer ldapServer) throws Exception {
        LdapConnection ldapConnection = LdapApiIntegrationUtils.getAdminPool(ldapServer).getConnection();
        ldapConnection.setBinaryAttributeDetector((BinaryAttributeDetector)new SchemaBinaryAttributeDetector(ldapServer.getDirectoryService().getSchemaManager()));
        return ldapConnection;
    }

    public static void releasePooledAdminConnection(LdapConnection conn, LdapServer ldapServer) throws Exception {
        LdapApiIntegrationUtils.getAdminPool(ldapServer).releaseConnection(conn);
    }

    private static LdapConnectionPool getAdminPool(LdapServer ldapServer) {
        int port = ldapServer.getPort();
        if (!pools.containsKey(port)) {
            LdapConnectionConfig config = new LdapConnectionConfig();
            config.setLdapHost(DEFAULT_HOST);
            config.setLdapPort(port);
            config.setName(DEFAULT_ADMIN);
            config.setCredentials(DEFAULT_PASSWORD);
            PoolableLdapConnectionFactory factory = new PoolableLdapConnectionFactory(config);
            LdapConnectionPool pool = new LdapConnectionPool(factory);
            pool.setTestOnBorrow(true);
            pools.put(port, pool);
        }
        return pools.get(port);
    }
}

