/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.tools;

import java.util.UUID;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.csn.CsnFactory;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreUtils {
    private static final CsnFactory CSN_FACTORY = new CsnFactory(0);

    public static void loadExampleData(Store<ServerEntry, Long> store, SchemaManager schemaManager) throws Exception {
        store.setSuffixDn("o=Good Times Co.");
        DN suffixDn = new DN("o=Good Times Co.");
        suffixDn.normalize(schemaManager.getNormalizerMapping());
        store.init(schemaManager);
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager, suffixDn);
        entry.add("objectClass", new String[]{"organization"});
        entry.add("o", new String[]{"Good Times Co."});
        entry.add("postalCode", new String[]{"1"});
        entry.add("postOfficeBox", new String[]{"1"});
        StoreUtils.injectEntryInStore(store, (ServerEntry)entry);
        DN dn = new DN("ou=Sales,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"top", "organizationalUnit"});
        entry.add("ou", new String[]{"Sales"});
        entry.add("postalCode", new String[]{"1"});
        entry.add("postOfficeBox", new String[]{"1"});
        StoreUtils.injectEntryInStore(store, (ServerEntry)entry);
        dn = new DN("ou=Board of Directors,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"top", "organizationalUnit"});
        entry.add("ou", new String[]{"Board of Directors"});
        entry.add("postalCode", new String[]{"1"});
        entry.add("postOfficeBox", new String[]{"1"});
        StoreUtils.injectEntryInStore(store, (ServerEntry)entry);
        dn = new DN("ou=Engineering,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"top", "organizationalUnit"});
        entry.add("ou", new String[]{"Engineering"});
        entry.add("postalCode", new String[]{"2"});
        entry.add("postOfficeBox", new String[]{"2"});
        StoreUtils.injectEntryInStore(store, (ServerEntry)entry);
        dn = new DN("cn=JOhnny WAlkeR,ou=Sales,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"top", "person", "organizationalPerson"});
        entry.add("ou", new String[]{"Sales"});
        entry.add("cn", new String[]{"JOhnny WAlkeR"});
        entry.add("sn", new String[]{"WAlkeR"});
        entry.add("postalCode", new String[]{"3"});
        entry.add("postOfficeBox", new String[]{"3"});
        StoreUtils.injectEntryInStore(store, (ServerEntry)entry);
        dn = new DN("cn=JIM BEAN,ou=Sales,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"top", "person", "organizationalPerson"});
        entry.add("ou", new String[]{"Sales"});
        entry.add("cn", new String[]{"JIM BEAN"});
        entry.add("surName", new String[]{"BEAN"});
        entry.add("postalCode", new String[]{"4"});
        entry.add("postOfficeBox", new String[]{"4"});
        StoreUtils.injectEntryInStore(store, (ServerEntry)entry);
        dn = new DN("ou=Apache,ou=Board of Directors,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"top", "organizationalUnit"});
        entry.add("ou", new String[]{"Apache"});
        entry.add("postalCode", new String[]{"5"});
        entry.add("postOfficeBox", new String[]{"5"});
        StoreUtils.injectEntryInStore(store, (ServerEntry)entry);
        dn = new DN("cn=Jack Daniels,ou=Engineering,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"top", "person", "organizationalPerson"});
        entry.add("ou", new String[]{"Engineering"});
        entry.add("cn", new String[]{"Jack Daniels"});
        entry.add("SN", new String[]{"Daniels"});
        entry.add("postalCode", new String[]{"6"});
        entry.add("postOfficeBox", new String[]{"6"});
        StoreUtils.injectEntryInStore(store, (ServerEntry)entry);
        dn = new DN("commonName=Jim Bean,ou=Apache,ou=Board of Directors,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"top", "alias", "extensibleObject"});
        entry.add("ou", new String[]{"Apache"});
        entry.add("commonName", new String[]{"Jim Bean"});
        entry.add("aliasedObjectName", new String[]{"cn=Jim Bean,ou=Sales,o=Good Times Co."});
        StoreUtils.injectEntryInStore(store, (ServerEntry)entry);
        dn = new DN("commonName=Jim Bean,ou=Board of Directors,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"top", "alias", "extensibleObject"});
        entry.add("commonName", new String[]{"Jim Bean"});
        entry.add("aliasedObjectName", new String[]{"cn=Jim Bean,ou=Sales,o=Good Times Co."});
        StoreUtils.injectEntryInStore(store, (ServerEntry)entry);
        dn = new DN("2.5.4.3=Johnny Walker,ou=Engineering,o=Good Times Co.");
        dn.normalize(schemaManager.getNormalizerMapping());
        entry = new DefaultServerEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"top", "alias", "extensibleObject"});
        entry.add("ou", new String[]{"Engineering"});
        entry.add("2.5.4.3", new String[]{"Johnny Walker"});
        entry.add("aliasedObjectName", new String[]{"cn=Johnny Walker,ou=Sales,o=Good Times Co."});
        StoreUtils.injectEntryInStore(store, (ServerEntry)entry);
    }

    public Entry getAttributes(Store<Object, Long> store, Long id) throws Exception {
        DefaultClientEntry entry = new DefaultClientEntry();
        entry.put("_nDn", new String[]{store.getEntryDn((Object)id)});
        entry.put("_upDn", new String[]{store.getEntryUpdn((Object)id)});
        entry.put("_parent", new String[]{Long.toString((Long)store.getParentId((Object)id))});
        for (Index index : store.getUserIndices()) {
            IndexCursor list = index.reverseCursor();
            ForwardIndexEntry recordForward = new ForwardIndexEntry();
            recordForward.setId((Object)id);
            list.before((Object)recordForward);
            while (list.next()) {
                IndexEntry rec = (IndexEntry)list.get();
                String val = rec.getValue().toString();
                String attrId = index.getAttribute().getName();
                EntryAttribute attr = entry.get(attrId);
                if (attr == null) {
                    attr = new DefaultClientAttribute(attrId);
                }
                attr.add(new String[]{val});
                entry.put(new EntryAttribute[]{attr});
            }
        }
        IndexCursor list = store.getPresenceIndex().reverseCursor();
        ForwardIndexEntry recordForward = new ForwardIndexEntry();
        recordForward.setId((Object)id);
        list.before((Object)recordForward);
        StringBuffer val = new StringBuffer();
        while (list.next()) {
            IndexEntry rec = (IndexEntry)list.get();
            val.append("_existence[");
            val.append(rec.getValue().toString());
            val.append("]");
            String valStr = val.toString();
            EntryAttribute attr = entry.get(valStr);
            if (attr == null) {
                attr = new DefaultClientAttribute(valStr);
            }
            attr.add(new String[]{rec.getId().toString()});
            entry.put(new EntryAttribute[]{attr});
            val.setLength(0);
        }
        IndexCursor children = store.getOneLevelIndex().forwardCursor();
        ForwardIndexEntry longRecordForward = new ForwardIndexEntry();
        recordForward.setId((Object)id);
        children.before((Object)longRecordForward);
        DefaultClientAttribute childAttr = new DefaultClientAttribute("_child");
        entry.put(new EntryAttribute[]{childAttr});
        while (children.next()) {
            IndexEntry rec = (IndexEntry)children.get();
            childAttr.add(new String[]{rec.getId().toString()});
        }
        return entry;
    }

    public static void injectEntryInStore(Store<ServerEntry, Long> store, ServerEntry entry) throws Exception {
        entry.add("entryCSN", new String[]{CSN_FACTORY.newInstance().toString()});
        entry.add("entryUUID", new String[]{UUID.randomUUID().toString()});
        store.add(entry);
    }
}

