/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.AllEntriesCursor;
import org.apache.directory.server.xdbm.search.impl.SubtreeScopeEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;

public class SubtreeScopeCursor<ID extends Comparable<ID>>
extends AbstractIndexCursor<ID, Entry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_719, (Object[])new Object[0]);
    private final Store<Entry, ID> db;
    private final SubtreeScopeEvaluator<Entry, ID> evaluator;
    private final IndexCursor<ID, Entry, ID> scopeCursor;
    private final IndexCursor<ID, Entry, ID> dereferencedCursor;
    private IndexCursor<ID, Entry, ID> cursor;
    private boolean available = false;
    private ID contextEntryId;

    public SubtreeScopeCursor(Store<Entry, ID> db, SubtreeScopeEvaluator<Entry, ID> evaluator) throws Exception {
        this.db = db;
        this.evaluator = evaluator;
        this.scopeCursor = evaluator.getBaseId() == this.getContextEntryId() ? new AllEntriesCursor<ID>(db) : db.getSubLevelIndex().forwardCursor(evaluator.getBaseId());
        this.dereferencedCursor = evaluator.isDereferencing() ? db.getSubAliasIndex().forwardCursor(evaluator.getBaseId()) : null;
    }

    private ID getContextEntryId() throws Exception {
        if (this.contextEntryId == null) {
            try {
                this.contextEntryId = this.db.getEntryId(((Partition)this.db).getSuffixDn());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.contextEntryId == null) {
            return this.db.getDefaultId();
        }
        return this.contextEntryId;
    }

    public boolean available() {
        return this.available;
    }

    @Override
    public void beforeValue(ID id, ID value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void before(IndexEntry<ID, Entry, ID> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void afterValue(ID id, ID value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void after(IndexEntry<ID, Entry, ID> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.cursor = this.scopeCursor;
        this.cursor.beforeFirst();
        this.available = false;
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.cursor = this.evaluator.isDereferencing() ? this.dereferencedCursor : this.scopeCursor;
        this.cursor.afterLast();
        this.available = false;
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.cursor == null) {
            this.afterLast();
        }
        if (this.cursor == this.scopeCursor) {
            if (this.evaluator.isDereferencing()) {
                do {
                    this.checkNotClosed("previous()");
                    this.available = this.cursor.previous();
                } while ((!this.available || this.db.getAliasIndex().reverseLookup(((IndexEntry)this.cursor.get()).getId()) != null) && this.available);
            } else {
                this.available = this.cursor.previous();
            }
            return this.available;
        }
        this.available = this.cursor.previous();
        if (!this.available) {
            this.cursor = this.scopeCursor;
            this.cursor.afterLast();
            do {
                this.checkNotClosed("previous()");
                this.available = this.cursor.previous();
            } while ((!this.available || this.db.getAliasIndex().reverseLookup(((IndexEntry)this.cursor.get()).getId()) != null) && this.available);
            return this.available;
        }
        return true;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.cursor == null) {
            this.beforeFirst();
        }
        if (this.evaluator.isDereferencing()) {
            do {
                this.checkNotClosed("next()");
                this.available = this.cursor.next();
            } while ((!this.available || this.db.getAliasIndex().reverseLookup(((IndexEntry)this.cursor.get()).getId()) != null) && this.available);
        } else {
            this.available = this.cursor.next();
        }
        if (this.cursor == this.dereferencedCursor) {
            return this.available;
        }
        if (!this.available) {
            if (this.dereferencedCursor != null) {
                this.cursor = this.dereferencedCursor;
                this.cursor.beforeFirst();
                this.available = this.cursor.next();
                return this.available;
            }
            return false;
        }
        return true;
    }

    public IndexEntry<ID, Entry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available) {
            return (IndexEntry)this.cursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    private void closeCursors() throws Exception {
        if (this.dereferencedCursor != null) {
            this.dereferencedCursor.close();
        }
        if (this.scopeCursor != null) {
            this.scopeCursor.close();
        }
    }

    @Override
    public void close() throws Exception {
        this.closeCursors();
        super.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        this.closeCursors();
        super.close(cause);
    }
}

