/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import org.apache.directory.server.xdbm.AbstractIndexEntry;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.ldap.model.cursor.Tuple;

public class ForwardIndexEntry<V, O, ID>
extends AbstractIndexEntry<V, O, ID> {
    private final Tuple<V, ID> tuple = new Tuple();

    public ForwardIndexEntry() {
        super(null);
    }

    public void setTuple(Tuple<V, ID> tuple, O object) {
        this.setObject(object);
        this.tuple.setKey(tuple.getKey());
        this.tuple.setValue(tuple.getValue());
    }

    @Override
    public ID getId() {
        return (ID)this.tuple.getValue();
    }

    @Override
    public V getValue() {
        return (V)this.tuple.getKey();
    }

    @Override
    public void setId(ID id) {
        this.tuple.setValue(id);
    }

    @Override
    public void setValue(V value) {
        this.tuple.setKey(value);
    }

    @Override
    public Tuple<V, ID> getTuple() {
        return this.tuple;
    }

    @Override
    public void clear() {
        super.clear();
        this.tuple.setKey(null);
        this.tuple.setValue(null);
    }

    @Override
    public void copy(IndexEntry<V, O, ID> entry) {
        super.copy(entry);
        this.tuple.setKey(entry.getValue());
        this.tuple.setValue(entry.getId());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ForwardIndexEntry[ ");
        buf.append(this.tuple.getKey());
        buf.append(", ");
        buf.append(this.tuple.getValue());
        buf.append(" ]");
        return buf.toString();
    }
}

