/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import org.apache.directory.server.core.cursor.InvalidCursorPositionException;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonIndexCursor<K, E>
extends AbstractIndexCursor<K, E> {
    private boolean beforeFirst = true;
    private boolean afterLast;
    private boolean onSingleton;
    private final IndexEntry<K, E> singleton;

    public SingletonIndexCursor(IndexEntry<K, E> singleton) {
        this.singleton = singleton;
    }

    public boolean available() {
        return this.onSingleton;
    }

    public void before(IndexEntry<K, E> element) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeValue(Long id, K value) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterValue(Long id, K value) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void after(IndexEntry<K, E> element) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = true;
        this.afterLast = false;
        this.onSingleton = false;
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.afterLast = true;
        this.onSingleton = false;
    }

    public boolean first() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    public boolean last() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    public boolean isFirst() throws Exception {
        this.checkNotClosed("()");
        return this.onSingleton;
    }

    public boolean isLast() throws Exception {
        this.checkNotClosed("()");
        return this.onSingleton;
    }

    public boolean isAfterLast() throws Exception {
        this.checkNotClosed("()");
        return this.afterLast;
    }

    public boolean isBeforeFirst() throws Exception {
        this.checkNotClosed("()");
        return this.beforeFirst;
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("()");
        if (this.beforeFirst) {
            return false;
        }
        if (this.afterLast) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        this.beforeFirst = true;
        this.onSingleton = false;
        this.afterLast = false;
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("()");
        if (this.beforeFirst) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        if (this.afterLast) {
            return false;
        }
        this.beforeFirst = false;
        this.onSingleton = false;
        this.afterLast = true;
        return false;
    }

    public IndexEntry<K, E> get() throws Exception {
        this.checkNotClosed("()");
        if (this.onSingleton) {
            return this.singleton;
        }
        if (this.beforeFirst) {
            throw new InvalidCursorPositionException("Cannot access element if positioned before first.");
        }
        throw new InvalidCursorPositionException("Cannot access element if positioned after last.");
    }

    public boolean isElementReused() {
        return true;
    }
}

