/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.wrapper;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.directory.api.util.Network;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.ApacheDsService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public final class ApacheDsTanukiWrapper
implements WrapperListener {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheDsTanukiWrapper.class);
    private ApacheDsService service;

    private ApacheDsTanukiWrapper() {
    }

    public static void main(String[] args) {
        WrapperManager.start((WrapperListener)new ApacheDsTanukiWrapper(), (String[])args);
    }

    private static int readShutdownPort(InstanceLayout layout) throws IOException {
        return Integer.parseInt(new String(Files.readAllBytes(Paths.get(layout.getRunDirectory().getAbsolutePath(), ".shutdown.port")), Charset.forName("utf-8")));
    }

    private static String readShutdownPassword(InstanceLayout layout) throws IOException {
        return new String(Files.readAllBytes(Paths.get(layout.getRunDirectory().getAbsolutePath(), ".shutdown.pwd")), Charset.forName("utf-8"));
    }

    public void repair(String instanceDirectory) {
        System.out.println("Trying to repair the following data :" + instanceDirectory);
        InstanceLayout layout = new InstanceLayout(instanceDirectory);
        this.service = new ApacheDsService();
        try {
            System.out.println("Starting the service.");
            this.service.start(layout);
            System.out.println("Service started.");
        }
        catch (Exception e) {
            return;
        }
        try {
            System.out.println("Repairing the database.");
            this.service.repair(layout);
            System.out.println("Database repaired.");
        }
        catch (Exception e) {
            LOG.error("Failed to start the service.", (Throwable)e);
            System.exit(1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Integer start(String[] args) {
        block41: {
            ApacheDsTanukiWrapper.LOG.info("Starting the service...");
            if (args != null) {
                argNb = 0;
                for (String arg : args) {
                    ApacheDsTanukiWrapper.LOG.info("Args[{}] : {}", (Object)argNb, (Object)arg);
                    ++argNb;
                }
            }
            if (args == null) break block41;
            action = "START";
            instanceDirectory = args[0];
            block10 : switch (args.length) {
                case 2: {
                    action = args[1];
                }
                case 1: {
                    this.service = new ApacheDsService();
                    instanceLayout = new InstanceLayout(instanceDirectory);
                    var5_8 = Strings.toLowerCaseAscii((String)action);
                    var6_10 = -1;
                    switch (var5_8.hashCode()) {
                        case 3540994: {
                            if (!var5_8.equals("stop")) break;
                            var6_10 = 0;
                            break;
                        }
                        case -934535283: {
                            if (!var5_8.equals("repair")) break;
                            var6_10 = 1;
                        }
                    }
                    switch (var6_10) {
                        case 0: {
                            ApacheDsTanukiWrapper.LOG.debug("Stopping runtime");
                            layout = new InstanceLayout(instanceDirectory);
                            try {
                                socket = new Socket(Network.LOOPBACK, ApacheDsTanukiWrapper.readShutdownPort(layout));
                                var9_15 = null;
                                writer = new PrintWriter(socket.getOutputStream());
                                var11_19 = null;
                                try {
                                    writer.print(ApacheDsTanukiWrapper.readShutdownPassword(layout));
                                }
                                catch (Throwable var12_21) {
                                    var11_19 = var12_21;
                                    throw var12_21;
                                }
                                finally {
                                    if (writer != null) {
                                        if (var11_19 != null) {
                                            try {
                                                writer.close();
                                            }
                                            catch (Throwable var12_20) {
                                                var11_19.addSuppressed(var12_20);
                                            }
                                        } else {
                                            writer.close();
                                        }
                                    }
                                }
                                if (socket == null) break block10;
                                if (var9_15 == null) ** GOTO lbl62
                                try {
                                    socket.close();
                                }
                                catch (Throwable var10_17) {
                                    var9_15.addSuppressed(var10_17);
                                }
                                break;
lbl62:
                                // 1 sources

                                socket.close();
                                break;
                                catch (Throwable var10_18) {
                                    try {
                                        var9_15 = var10_18;
                                        throw var10_18;
                                    }
                                    catch (Throwable var15_24) {
                                        if (socket != null) {
                                            if (var9_15 != null) {
                                                try {
                                                    socket.close();
                                                }
                                                catch (Throwable var16_25) {
                                                    var9_15.addSuppressed(var16_25);
                                                }
                                            } else {
                                                socket.close();
                                            }
                                        }
                                        throw var15_24;
                                    }
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                break;
                            }
                        }
                        case 1: {
                            ApacheDsTanukiWrapper.LOG.debug("Fixing the database runtime");
                            this.repair(instanceDirectory);
                            break;
                        }
                        default: {
                            ApacheDsTanukiWrapper.LOG.debug("Starting runtime");
                            try {
                                this.service.start(instanceLayout);
                            }
                            catch (Exception e) {
                                ApacheDsTanukiWrapper.LOG.error("Failed to start the service.", (Throwable)e);
                                System.exit(5);
                            }
                            break;
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Program must be launched with at least 1 argument, the path to the instance directory.");
                }
            }
        }
        return null;
    }

    public int stop(int exitCode) {
        LOG.info("Attempting graceful shutdown of the service...");
        try {
            this.service.stop();
        }
        catch (Exception e) {
            LOG.error("Failed to stop the service.", (Throwable)e);
            System.exit(6);
        }
        LOG.info("Completed graceful shutdown of the service...");
        return exitCode;
    }

    public void controlEvent(int event) {
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop((int)0);
        }
    }
}

