/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.api;

import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.Control;

public abstract class ControlDecorator<E extends Control>
implements CodecControl<E> {
    private E decorated;
    protected int valueLength;
    protected byte[] value;
    private LdapApiService codec;

    public ControlDecorator(LdapApiService codec, E decoratedControl) {
        this.decorated = decoratedControl;
        this.codec = codec;
    }

    @Override
    public E getDecorated() {
        return this.decorated;
    }

    public void setDecorated(E decorated) {
        this.decorated = decorated;
    }

    @Override
    public LdapApiService getCodecService() {
        return this.codec;
    }

    @Override
    public String getOid() {
        return this.decorated.getOid();
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(byte[] value) {
        if (value != null) {
            byte[] copy = new byte[value.length];
            System.arraycopy(value, 0, copy, 0, value.length);
            this.value = copy;
        } else {
            this.value = null;
        }
    }

    @Override
    public boolean isCritical() {
        return this.decorated.isCritical();
    }

    @Override
    public void setCritical(boolean criticality) {
        this.decorated.setCritical(criticality);
    }

    public int hashCode() {
        return this.decorated.hashCode();
    }

    public boolean equals(Object o) {
        if (this.decorated == null) {
            return o == null;
        }
        return this.decorated.equals(o);
    }

    public String toString() {
        return this.decorated.toString();
    }
}

