/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.sam;

import java.util.EnumMap;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.kerberos.KerberosKey;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.sam.KeyIntegrityChecker;
import org.apache.directory.server.kerberos.sam.SamException;
import org.apache.directory.server.kerberos.sam.SamVerifier;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.shared.kerberos.codec.types.SamType;

public final class SamSubsystem {
    public static final String PROPKEY_BASE = "kerberos.sam.type.";
    private static SamSubsystem instance;
    private final EnumMap<SamType, SamVerifier> verifiers = new EnumMap(SamType.class);
    private KeyIntegrityChecker keyChecker;
    private DirContext userContext;
    private String userBaseRdn;

    public static SamSubsystem getInstance() {
        if (instance == null) {
            instance = new SamSubsystem();
        }
        return instance;
    }

    public void setIntegrityChecker(KeyIntegrityChecker keyChecker) {
        this.keyChecker = keyChecker;
    }

    public KerberosKey verify(PrincipalStoreEntry entry, byte[] sad) throws SamException {
        SamVerifier verifier = null;
        if (this.keyChecker == null) {
            throw new IllegalStateException(I18n.err(I18n.ERR_651, new Object[0]));
        }
        if (entry.getSamType() == null) {
            throw new SamException(entry.getSamType(), I18n.err(I18n.ERR_652, new Object[0]));
        }
        if (this.verifiers.containsKey((Object)entry.getSamType())) {
            verifier = this.verifiers.get((Object)entry.getSamType());
            return verifier.verify(entry.getPrincipal(), sad);
        }
        String key = PROPKEY_BASE + entry.getSamType().getOrdinal();
        Hashtable env = new Hashtable();
        try {
            env.putAll(this.userContext.getEnvironment());
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        if (!env.containsKey(key)) {
            String msg = I18n.err(I18n.ERR_653, key);
            throw new SamException(entry.getSamType(), msg);
        }
        String fqcn = (String)env.get(key);
        try {
            Class<?> c = Class.forName(fqcn);
            verifier = (SamVerifier)c.newInstance();
            try {
                verifier.setUserContext((DirContext)this.userContext.lookup(this.userBaseRdn));
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            verifier.setIntegrityChecker(this.keyChecker);
            verifier.startup();
            if (!verifier.getSamType().equals((Object)entry.getSamType())) {
                String msg = I18n.err(I18n.ERR_654, new Object[]{verifier.getSamType(), entry.getSamType()});
                throw new SamException(entry.getSamType(), msg);
            }
            this.verifiers.put(verifier.getSamType(), verifier);
            return verifier.verify(entry.getPrincipal(), sad);
        }
        catch (ClassNotFoundException e) {
            String msg = I18n.err(I18n.ERR_655, new Object[]{fqcn, entry.getSamType()});
            throw new SamException(entry.getSamType(), msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = I18n.err(I18n.ERR_656, new Object[]{fqcn, entry.getSamType()});
            throw new SamException(entry.getSamType(), msg, e);
        }
        catch (InstantiationException e) {
            String msg = I18n.err(I18n.ERR_657, new Object[]{fqcn, entry.getSamType()});
            throw new SamException(entry.getSamType(), msg, e);
        }
    }

    public void setUserContext(DirContext userContext, String userBaseRdn) {
        this.userContext = userContext;
        this.userBaseRdn = userBaseRdn;
    }
}

