/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.AttributesFactory;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.parsers.LdapComparatorDescription;
import org.apache.directory.api.ldap.model.schema.parsers.NormalizerDescription;
import org.apache.directory.api.ldap.model.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.util.Base64;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.partition.Partition;

public class SchemaSubentryModifier {
    private AttributesFactory factory = new AttributesFactory();
    private SchemaManager schemaManager;
    private DnFactory dnFactory;

    public SchemaSubentryModifier(SchemaManager schemaManager, DnFactory dnFactory) {
        this.schemaManager = schemaManager;
        this.dnFactory = dnFactory;
    }

    private Dn getDn(SchemaObject obj) throws LdapInvalidDnException {
        StringBuilder buf = new StringBuilder();
        buf.append("m-oid=").append(obj.getOid()).append(",ou=");
        if (obj instanceof LdapSyntax) {
            buf.append("Syntaxes");
        } else if (obj instanceof MatchingRule) {
            buf.append("matchingRules");
        } else if (obj instanceof AttributeType) {
            buf.append("attributeTypes");
        } else if (obj instanceof ObjectClass) {
            buf.append("objectClasses");
        } else if (obj instanceof MatchingRuleUse) {
            buf.append("matchingRuleUse");
        } else if (obj instanceof DitStructureRule) {
            buf.append("ditStructureRules");
        } else if (obj instanceof DitContentRule) {
            buf.append("ditContentRules");
        } else if (obj instanceof NameForm) {
            buf.append("nameForms");
        }
        buf.append(",cn=").append(obj.getSchemaName()).append(",ou=schema");
        return this.dnFactory.create(buf.toString());
    }

    public void add(Interceptor nextInterceptor, int position, ModifyOperationContext modifyContext, LdapComparatorDescription comparatorDescription) throws LdapException {
        String schemaName = this.getSchema(comparatorDescription);
        Dn dn = this.dnFactory.create("m-oid=" + comparatorDescription.getOid(), "ou=comparators", "cn=" + schemaName, "ou=schema");
        Entry entry = this.getEntry(dn, comparatorDescription);
        Partition partition = modifyContext.getSession().getDirectoryService().getPartitionNexus().getPartition(dn);
        AddOperationContext addContext = new AddOperationContext(modifyContext.getSession(), entry);
        addContext.setCurrentInterceptor(position);
        addContext.setPartition(partition);
        addContext.setTransaction(modifyContext.getTransaction());
        nextInterceptor.add(addContext);
    }

    public void add(Interceptor nextInterceptor, int position, ModifyOperationContext modifyContext, NormalizerDescription normalizerDescription) throws LdapException {
        String schemaName = this.getSchema(normalizerDescription);
        Dn dn = this.dnFactory.create("m-oid=" + normalizerDescription.getOid(), "ou=normalizers", "cn=" + schemaName, "ou=schema");
        Entry entry = this.getEntry(dn, normalizerDescription);
        Partition partition = modifyContext.getSession().getDirectoryService().getPartitionNexus().getPartition(dn);
        AddOperationContext addContext = new AddOperationContext(modifyContext.getSession(), entry);
        addContext.setCurrentInterceptor(position);
        addContext.setPartition(partition);
        addContext.setTransaction(modifyContext.getTransaction());
        nextInterceptor.add(addContext);
    }

    public void add(Interceptor nextInterceptor, int position, ModifyOperationContext modifyContext, SyntaxCheckerDescription syntaxCheckerDescription) throws LdapException {
        String schemaName = this.getSchema(syntaxCheckerDescription);
        Dn dn = this.dnFactory.create("m-oid=" + syntaxCheckerDescription.getOid(), "ou=syntaxcheckers", "cn=" + schemaName, "ou=schema");
        Entry entry = this.getEntry(dn, syntaxCheckerDescription);
        Partition partition = modifyContext.getSession().getDirectoryService().getPartitionNexus().getPartition(dn);
        AddOperationContext addContext = new AddOperationContext(modifyContext.getSession(), entry);
        addContext.setCurrentInterceptor(position);
        addContext.setPartition(partition);
        addContext.setTransaction(modifyContext.getTransaction());
        nextInterceptor.add(addContext);
    }

    public void addSchemaObject(Interceptor nextInterceptor, int position, ModifyOperationContext modifyContext, SchemaObject obj) throws LdapException {
        Schema schema = this.schemaManager.getLoadedSchema(obj.getSchemaName());
        Dn dn = this.getDn(obj);
        Entry entry = this.factory.getAttributes(obj, schema, this.schemaManager);
        entry.setDn(dn);
        Partition partition = modifyContext.getSession().getDirectoryService().getPartitionNexus().getPartition(dn);
        AddOperationContext addContext = new AddOperationContext(modifyContext.getSession(), entry);
        addContext.setCurrentInterceptor(position);
        addContext.setPartition(partition);
        addContext.setTransaction(modifyContext.getTransaction());
        nextInterceptor.add(addContext);
    }

    public void deleteSchemaObject(Interceptor nextInterceptor, int position, ModifyOperationContext modifyContext, SchemaObject obj) throws LdapException {
        Dn dn = this.getDn(obj);
        Partition partition = modifyContext.getSession().getDirectoryService().getPartitionNexus().getPartition(dn);
        DeleteOperationContext deleteContext = new DeleteOperationContext(modifyContext.getSession(), dn);
        deleteContext.setEntry(modifyContext.getSession().lookup(dn, new String[0]));
        deleteContext.setCurrentInterceptor(position);
        deleteContext.setPartition(partition);
        deleteContext.setTransaction(modifyContext.getTransaction());
        nextInterceptor.delete(deleteContext);
    }

    public void delete(Interceptor nextInterceptor, int position, ModifyOperationContext modifyContext, NormalizerDescription normalizerDescription) throws LdapException {
        String schemaName = this.getSchema(normalizerDescription);
        Dn dn = this.dnFactory.create("m-oid=" + normalizerDescription.getOid(), "ou=normalizers", "cn=" + schemaName, "ou=schema");
        Partition partition = modifyContext.getSession().getDirectoryService().getPartitionNexus().getPartition(dn);
        DeleteOperationContext deleteContext = new DeleteOperationContext(modifyContext.getSession(), dn);
        deleteContext.setEntry(modifyContext.getSession().lookup(dn, new String[0]));
        deleteContext.setCurrentInterceptor(position);
        deleteContext.setPartition(partition);
        deleteContext.setTransaction(modifyContext.getTransaction());
        nextInterceptor.delete(deleteContext);
    }

    public void delete(Interceptor nextInterceptor, int position, ModifyOperationContext modifyContext, SyntaxCheckerDescription syntaxCheckerDescription) throws LdapException {
        String schemaName = this.getSchema(syntaxCheckerDescription);
        Dn dn = this.dnFactory.create("m-oid=" + syntaxCheckerDescription.getOid(), "ou=syntaxcheckers", "cn=" + schemaName, "ou=schema");
        Partition partition = modifyContext.getSession().getDirectoryService().getPartitionNexus().getPartition(dn);
        DeleteOperationContext deleteContext = new DeleteOperationContext(modifyContext.getSession(), dn);
        deleteContext.setEntry(modifyContext.getSession().lookup(dn, new String[0]));
        deleteContext.setCurrentInterceptor(position);
        deleteContext.setPartition(partition);
        deleteContext.setTransaction(modifyContext.getTransaction());
        nextInterceptor.delete(deleteContext);
    }

    public void delete(Interceptor nextInterceptor, int position, ModifyOperationContext modifyContext, LdapComparatorDescription comparatorDescription) throws LdapException {
        String schemaName = this.getSchema(comparatorDescription);
        Dn dn = this.dnFactory.create("m-oid=" + comparatorDescription.getOid(), "ou=comparators", "cn=" + schemaName, "ou=schema");
        Partition partition = modifyContext.getSession().getDirectoryService().getPartitionNexus().getPartition(dn);
        DeleteOperationContext deleteContext = new DeleteOperationContext(modifyContext.getSession(), dn);
        deleteContext.setEntry(modifyContext.getSession().lookup(dn, new String[0]));
        deleteContext.setCurrentInterceptor(position);
        deleteContext.setPartition(partition);
        deleteContext.setTransaction(modifyContext.getTransaction());
        nextInterceptor.delete(deleteContext);
    }

    private Entry getEntry(Dn dn, LdapComparatorDescription comparatorDescription) {
        DefaultEntry entry = new DefaultEntry(this.schemaManager, dn);
        entry.put("objectClass", "top", "metaTop", "metaComparator");
        entry.put("m-oid", comparatorDescription.getOid());
        entry.put("m-fqcn", comparatorDescription.getFqcn());
        if (comparatorDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode(comparatorDescription.getBytecode().toCharArray())});
        }
        if (comparatorDescription.getDescription() != null) {
            entry.put("m-description", comparatorDescription.getDescription());
        }
        return entry;
    }

    private Entry getEntry(Dn dn, NormalizerDescription normalizerDescription) {
        DefaultEntry entry = new DefaultEntry(this.schemaManager, dn);
        entry.put("objectClass", "top", "metaTop", "metaNormalizer");
        entry.put("m-oid", normalizerDescription.getOid());
        entry.put("m-fqcn", normalizerDescription.getFqcn());
        if (normalizerDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode(normalizerDescription.getBytecode().toCharArray())});
        }
        if (normalizerDescription.getDescription() != null) {
            entry.put("m-description", normalizerDescription.getDescription());
        }
        return entry;
    }

    private String getSchema(SchemaObject desc) {
        if (desc.getExtensions().containsKey("X-SCHEMA")) {
            return desc.getExtensions().get("X-SCHEMA").get(0);
        }
        return "other";
    }

    private Entry getEntry(Dn dn, SyntaxCheckerDescription syntaxCheckerDescription) {
        DefaultEntry entry = new DefaultEntry(this.schemaManager, dn);
        entry.put("objectClass", "top", "metaTop", "metaSyntaxChecker");
        entry.put("m-oid", syntaxCheckerDescription.getOid());
        entry.put("m-fqcn", syntaxCheckerDescription.getFqcn());
        if (syntaxCheckerDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode(syntaxCheckerDescription.getBytecode().toCharArray())});
        }
        if (syntaxCheckerDescription.getDescription() != null) {
            entry.put("m-description", syntaxCheckerDescription.getDescription());
        }
        return entry;
    }
}

