/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.xdbm.search.Optimizer;

public class NoOpOptimizer
implements Optimizer {
    private static final Long MAX = Long.MAX_VALUE;

    @Override
    public Long annotate(PartitionTxn partitionTxn, ExprNode node) throws LdapException {
        if (node.isLeaf()) {
            node.set("count", MAX);
            return MAX;
        }
        BranchNode bnode = (BranchNode)node;
        if (bnode.getChildren().size() == 0) {
            bnode.set("count", MAX);
            return MAX;
        }
        int limit = bnode.getChildren().size();
        for (int ii = 0; ii < limit; ++ii) {
            ExprNode child = bnode.getChildren().get(ii);
            if (child.isLeaf()) {
                child.set("count", MAX);
                continue;
            }
            this.annotate(partitionTxn, child);
        }
        bnode.set("count", MAX);
        return MAX;
    }
}

