/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.ldif;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.directory.api.ldap.model.csn.CsnFactory;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.partition.PartitionReadTxn;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.api.partition.PartitionWriteTxn;
import org.apache.directory.server.core.partition.ldif.AbstractLdifPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.SingletonIndexCursor;
import org.apache.directory.server.xdbm.search.cursor.DescendantCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifPartition
extends AbstractLdifPartition {
    private static final Logger LOG = LoggerFactory.getLogger(LdifPartition.class);
    private File suffixDirectory;
    private static final boolean CREATE = Boolean.TRUE;
    private static final boolean DELETE = Boolean.FALSE;
    private FileFilter dirFilter = new FileFilter(){

        @Override
        public boolean accept(File dir) {
            return dir.isDirectory();
        }
    };
    private FileFilter entryFilter = new FileFilter(){

        @Override
        public boolean accept(File dir) {
            if (dir.getName().endsWith(".ldif")) {
                return dir.isFile();
            }
            return false;
        }
    };

    public LdifPartition(SchemaManager schemaManager, DnFactory dnFactory) {
        super(schemaManager, dnFactory);
    }

    @Override
    protected void doInit() throws LdapException {
        if (!this.initialized) {
            File partitionDir = new File(this.getPartitionPath());
            if (this.suffixDn == null || this.suffixDn.isEmpty()) {
                String msg = I18n.err(I18n.ERR_150, new Object[0]);
                LOG.error(msg);
                throw new LdapInvalidDnException(msg);
            }
            if (!this.suffixDn.isSchemaAware()) {
                this.suffixDn = new Dn(this.schemaManager, this.suffixDn);
            }
            String suffixDirName = this.getFileName(this.suffixDn);
            this.suffixDirectory = new File(partitionDir, suffixDirName);
            super.doInit();
            if (this.suffixDirectory.exists()) {
                this.loadEntries(partitionDir);
            } else {
                block49: {
                    try {
                        this.suffixDirectory.mkdirs();
                    }
                    catch (SecurityException se) {
                        String msg = I18n.err(I18n.ERR_151, this.suffixDirectory.getAbsolutePath(), se.getLocalizedMessage());
                        LOG.error(msg);
                        throw se;
                    }
                    File contextEntryFile = new File(this.suffixDirectory + ".ldif");
                    LOG.info("ldif file doesn't exist {}, creating it.", (Object)contextEntryFile.getAbsolutePath());
                    if (this.contextEntry == null) {
                        if (contextEntryFile.exists()) {
                            try (LdifReader reader = new LdifReader(contextEntryFile);){
                                this.contextEntry = new DefaultEntry(this.schemaManager, reader.next().getEntry());
                                break block49;
                            }
                            catch (IOException ioe) {
                                throw new LdapOtherException(ioe.getMessage(), ioe);
                            }
                        }
                        return;
                    }
                }
                if (this.suffixDn != null && this.contextEntry != null) {
                    Dn contextEntryDn = this.contextEntry.getDn();
                    if (!contextEntryDn.isSchemaAware()) {
                        contextEntryDn = new Dn(this.schemaManager, contextEntryDn);
                    }
                    if (this.suffixDn.equals(contextEntryDn)) {
                        Entry suffixEntry;
                        LookupOperationContext lookupContext = new LookupOperationContext(null, this.suffixDn);
                        lookupContext.setPartition(this);
                        try (PartitionReadTxn partitionTxn = this.beginReadTransaction();){
                            lookupContext.setTransaction(partitionTxn);
                            suffixEntry = this.lookup(lookupContext);
                        }
                        catch (IOException ioe) {
                            throw new LdapOtherException(ioe.getMessage(), ioe);
                        }
                        if (suffixEntry == null) {
                            if (!this.contextEntry.isSchemaAware()) {
                                this.contextEntry = new DefaultEntry(this.schemaManager, this.contextEntry);
                            }
                            if (this.contextEntry.get("entryCSN") == null) {
                                this.contextEntry.add("entryCSN", new CsnFactory(0).newInstance().toString());
                            }
                            if (this.contextEntry.get("entryUUID") == null) {
                                String uuid = UUID.randomUUID().toString();
                                this.contextEntry.add("entryUUID", uuid);
                            }
                            AddOperationContext addContext = new AddOperationContext(null, this.contextEntry);
                            addContext.setPartition(this);
                            PartitionWriteTxn partitionTxn = null;
                            try {
                                partitionTxn = this.beginWriteTransaction();
                                addContext.setTransaction(partitionTxn);
                                this.add(addContext);
                                partitionTxn.commit();
                            }
                            catch (Exception e) {
                                try {
                                    if (partitionTxn != null) {
                                        partitionTxn.abort();
                                    }
                                }
                                catch (IOException ioe) {
                                    throw new LdapOtherException(ioe.getMessage(), ioe);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        super.add(addContext);
        this.addEntry(addContext.getEntry());
    }

    @Override
    public Entry delete(PartitionTxn partitionTxn, String id) throws LdapException {
        Entry deletedEntry = super.delete(partitionTxn, id);
        if (deletedEntry != null) {
            File ldifFile = this.getFile(deletedEntry.getDn(), DELETE);
            boolean deleted = this.deleteFile(ldifFile);
            LOG.debug("deleted file {} {}", (Object)ldifFile.getAbsoluteFile(), (Object)deleted);
            File parentFile = ldifFile.getParentFile();
            if (parentFile.listFiles().length == 0) {
                this.deleteFile(parentFile);
                LOG.debug("deleted file {} {}", (Object)parentFile.getAbsoluteFile(), (Object)deleted);
            }
        }
        return deletedEntry;
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        PartitionTxn partitionTxn = modifyContext.getTransaction();
        String id = this.getEntryId(partitionTxn, modifyContext.getDn());
        try {
            super.modify(modifyContext.getTransaction(), modifyContext.getDn(), modifyContext.getModItems().toArray(new Modification[0]));
        }
        catch (Exception e) {
            throw new LdapOperationException(e.getMessage(), e);
        }
        Entry modifiedEntry = this.fetch(modifyContext.getTransaction(), id, modifyContext.getDn());
        modifyContext.setAlteredEntry(modifiedEntry);
        modifiedEntry.removeAttributes(this.entryDnAT);
        Dn dn = modifyContext.getDn();
        try {
            FileWriter fw = new FileWriter(this.getFile(dn, DELETE));
            fw.write(LdifUtils.convertToLdif(modifiedEntry, true));
            fw.close();
        }
        catch (IOException ioe) {
            throw new LdapOperationException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        PartitionTxn partitionTxn = moveContext.getTransaction();
        Dn oldDn = moveContext.getDn();
        String id = this.getEntryId(partitionTxn, oldDn);
        super.move(moveContext);
        Entry modifiedEntry = this.fetch(moveContext.getTransaction(), id, moveContext.getNewDn());
        try {
            this.entryMoved(partitionTxn, oldDn, modifiedEntry, id);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        PartitionTxn partitionTxn = moveAndRenameContext.getTransaction();
        Dn oldDn = moveAndRenameContext.getDn();
        String id = this.getEntryId(partitionTxn, oldDn);
        super.moveAndRename(moveAndRenameContext);
        Entry modifiedEntry = this.fetch(moveAndRenameContext.getTransaction(), id, moveAndRenameContext.getNewDn());
        moveAndRenameContext.setModifiedEntry(modifiedEntry);
        try {
            this.entryMoved(partitionTxn, oldDn, modifiedEntry, id);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        PartitionTxn partitionTxn = renameContext.getTransaction();
        Dn oldDn = renameContext.getDn();
        String entryId = this.getEntryId(partitionTxn, oldDn);
        super.rename(renameContext);
        Dn newDn = oldDn.getParent().add(renameContext.getNewRdn());
        Entry modifiedEntry = this.fetch(renameContext.getTransaction(), entryId, newDn);
        renameContext.setModifiedEntry(modifiedEntry);
        try {
            this.entryMoved(partitionTxn, oldDn, modifiedEntry, entryId);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    private void entryMoved(PartitionTxn partitionTxn, Dn oldEntryDn, Entry modifiedEntry, String entryIdOld) throws LdapException {
        this.addEntry(modifiedEntry);
        String baseId = this.getEntryId(partitionTxn, modifiedEntry.getDn());
        ParentIdAndRdn parentIdAndRdn = this.getRdnIndex().reverseLookup(partitionTxn, baseId);
        IndexEntry<ParentIdAndRdn, String> indexEntry = new IndexEntry<ParentIdAndRdn, String>();
        indexEntry.setId(baseId);
        indexEntry.setKey(parentIdAndRdn);
        SingletonIndexCursor<ParentIdAndRdn> cursor = new SingletonIndexCursor<ParentIdAndRdn>(partitionTxn, indexEntry);
        String parentId = parentIdAndRdn.getParentId();
        DescendantCursor scopeCursor = new DescendantCursor(partitionTxn, this, baseId, parentId, cursor);
        try {
            while (scopeCursor.next()) {
                IndexEntry entry = (IndexEntry)scopeCursor.get();
                if (entry.getId() == entryIdOld) continue;
                this.addEntry(this.fetch(partitionTxn, (String)entry.getId()));
            }
            scopeCursor.close();
        }
        catch (Exception e) {
            throw new LdapOperationException(e.getMessage(), e);
        }
        File file = this.getFile(oldEntryDn, DELETE);
        boolean deleted = this.deleteFile(file);
        LOG.warn("move operation: deleted file {} {}", (Object)file.getAbsoluteFile(), (Object)deleted);
        String dirName = file.getAbsolutePath();
        dirName = dirName.substring(0, dirName.indexOf(".ldif"));
        deleted = this.deleteFile(new File(dirName));
        LOG.warn("move operation: deleted dir {} {}", (Object)dirName, (Object)deleted);
    }

    private void loadEntries(File entryDir) throws LdapException {
        LOG.debug("Processing dir {}", (Object)entryDir.getName());
        File[] entries = entryDir.listFiles(this.entryFilter);
        if (entries != null && entries.length != 0) {
            LdifReader ldifReader = new LdifReader(this.schemaManager);
            for (File entry : entries) {
                LOG.debug("parsing ldif file {}", (Object)entry.getName());
                List<LdifEntry> ldifEntries = ldifReader.parseLdifFile(entry.getAbsolutePath());
                try {
                    ldifReader.close();
                }
                catch (IOException ioe) {
                    throw new LdapOtherException(ioe.getMessage(), ioe);
                }
                if (ldifEntries == null || ldifEntries.isEmpty()) continue;
                LdifEntry ldifEntry = ldifEntries.get(0);
                LOG.debug("Adding entry {}", (Object)ldifEntry);
                DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
                if (!serverEntry.containsAttribute("entryCSN")) {
                    serverEntry.put("entryCSN", defaultCSNFactory.newInstance().toString());
                }
                if (!serverEntry.containsAttribute("entryUUID")) {
                    serverEntry.put("entryUUID", UUID.randomUUID().toString());
                }
                AddOperationContext addContext = new AddOperationContext(null, serverEntry);
                PartitionWriteTxn partitionTxn = this.beginWriteTransaction();
                try {
                    addContext.setTransaction(partitionTxn);
                    addContext.setPartition(this);
                    super.add(addContext);
                    partitionTxn.commit();
                }
                catch (LdapException le) {
                    try {
                        partitionTxn.abort();
                    }
                    catch (IOException ioe) {
                        throw new LdapOtherException(ioe.getMessage(), ioe);
                    }
                    throw le;
                }
                catch (IOException ioe) {
                    try {
                        partitionTxn.abort();
                    }
                    catch (IOException ioe2) {
                        throw new LdapOtherException(ioe2.getMessage(), ioe2);
                    }
                    throw new LdapOtherException(ioe.getMessage(), ioe);
                }
            }
        } else {
            return;
        }
        File[] dirs = entryDir.listFiles(this.dirFilter);
        if (dirs != null && dirs.length != 0) {
            for (File f : dirs) {
                this.loadEntries(f);
            }
        }
    }

    private File getFile(Dn entryDn, boolean create) throws LdapException {
        String parentDir = null;
        String rdnFileName = null;
        if (entryDn.equals(this.suffixDn)) {
            parentDir = this.suffixDirectory.getParent() + File.separator;
            rdnFileName = this.suffixDn.getName() + ".ldif";
        } else {
            StringBuilder filePath = new StringBuilder();
            filePath.append(this.suffixDirectory).append(File.separator);
            Dn baseDn = entryDn.getDescendantOf(this.suffixDn);
            int size = baseDn.size();
            for (int i = 0; i < size - 1; ++i) {
                rdnFileName = this.getFileName(baseDn.getRdn(size - 1 - i));
                filePath.append(rdnFileName).append(File.separator);
            }
            rdnFileName = this.getFileName(entryDn.getRdn()) + ".ldif";
            parentDir = filePath.toString();
        }
        File dir = new File(parentDir);
        if (!dir.exists() && create && !dir.mkdir()) {
            throw new LdapException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECTORY, dir));
        }
        File ldifFile = new File(parentDir + rdnFileName);
        if (ldifFile.exists() && create) {
            throw new LdapException(I18n.err(I18n.ERR_633, new Object[0]));
        }
        return ldifFile;
    }

    private String getFileName(Rdn rdn) throws LdapException {
        StringBuilder fileName = new StringBuilder("");
        Iterator<Ava> iterator = rdn.iterator();
        while (iterator.hasNext()) {
            Ava ava = iterator.next();
            String normAT = ava.getNormType();
            AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(normAT);
            String atName = at.getName();
            String normValue = null;
            normValue = at.getSyntax().isHumanReadable() ? ava.getValue().getValue() : Strings.utf8ToString(ava.getValue().getBytes());
            fileName.append(atName).append("=").append(normValue);
            if (!iterator.hasNext()) continue;
            fileName.append("+");
        }
        return this.getOSFileName(fileName.toString());
    }

    private String getFileName(Dn dn) throws LdapException {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Rdn rdn : dn.getRdns()) {
            String normAT = rdn.getNormType();
            AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(normAT);
            String atName = at.getName();
            String normValue = rdn.getAva().getValue().getValue();
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(atName).append("=").append(normValue);
        }
        return this.getOSFileName(sb.toString());
    }

    private String getOSFileName(String fileName) {
        StringBuilder sb = new StringBuilder();
        block3: for (char c : fileName.toCharArray()) {
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '|': 
                case '\u007f': {
                    sb.append("%").append(Strings.dumpHex((byte)(c >> 4))).append(Strings.dumpHex((byte)(c & 0xF)));
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return Strings.toLowerCaseAscii(sb.toString());
    }

    private void addEntry(Entry entry) throws LdapException {
        entry.removeAttributes(this.entryDnAT);
        try {
            FileWriter fw = new FileWriter(this.getFile(entry.getDn(), CREATE));
            fw.write(LdifUtils.convertToLdif(entry));
            fw.close();
        }
        catch (IOException ioe) {
            throw new LdapOperationException(ioe.getMessage(), ioe);
        }
    }

    private boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.deleteFile(f);
            }
            return file.delete();
        }
        return file.delete();
    }
}

