/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import jdbm.RecordManager;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import jdbm.recman.TransactionManager;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.directory.api.ldap.model.csn.CsnFactory;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.exception.MultiException;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionReadTxn;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.api.partition.PartitionWriteTxn;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmDnIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmMasterTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartitionWriteTxn;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmRdnIndex;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.DefaultOptimizer;
import org.apache.directory.server.xdbm.search.impl.DefaultSearchEngine;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.NoOpOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbmPartition
extends AbstractBTreePartition {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmPartition.class);
    private static final String JDBM_DB_FILE_EXTN = ".db";
    private static final FilenameFilter DB_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(JdbmPartition.JDBM_DB_FILE_EXTN) && !name.startsWith("master.");
        }
    };
    private RecordManager recMan;
    private Cache entryCache;

    public JdbmPartition(SchemaManager schemaManager, DnFactory dnFactory) {
        super(schemaManager, dnFactory);
        if (this.cacheSize < 0) {
            this.cacheSize = 10000;
            LOG.debug("Using the default entry cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
        } else {
            LOG.debug("Using the custom configured cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
        }
    }

    private int rebuildIndexes(PartitionTxn partitionTxn) throws LdapException, IOException {
        Cursor cursor = this.getMasterTable().cursor();
        int masterTableCount = 0;
        int repaired = 0;
        System.out.println("Re-building indices...");
        boolean ctxEntryLoaded = false;
        try {
            while (cursor.next()) {
                Attribute entryCsn;
                ++masterTableCount;
                Tuple tuple = cursor.get();
                String id = (String)tuple.getKey();
                Entry entry = (Entry)tuple.getValue();
                String parentId = entry.get("1.3.6.1.4.1.18060.0.4.1.2.51").getString();
                System.out.println("Read entry " + entry.getDn() + " with ID " + id + " and parent ID " + parentId);
                Dn dn = entry.getDn();
                ParentIdAndRdn parentIdAndRdn = null;
                if (!ctxEntryLoaded && this.getSuffixDn().getName().startsWith(dn.getName())) {
                    parentIdAndRdn = new ParentIdAndRdn(parentId, this.getSuffixDn().getRdns());
                    ctxEntryLoaded = true;
                } else {
                    parentIdAndRdn = new ParentIdAndRdn(parentId, dn.getRdn());
                }
                this.rdnIdx.add(partitionTxn, parentIdAndRdn, id);
                Attribute objectClass = entry.get(this.objectClassAT);
                if (objectClass == null) {
                    String msg = I18n.err(I18n.ERR_217, dn, entry);
                    ResultCodeEnum rc = ResultCodeEnum.OBJECT_CLASS_VIOLATION;
                    throw new LdapSchemaViolationException(rc, msg);
                }
                for (Value value : objectClass) {
                    String valueStr = value.getValue();
                    if (valueStr.equals("top")) continue;
                    this.objectClassIdx.add(partitionTxn, valueStr, id);
                }
                if (objectClass.contains("alias")) {
                    Attribute aliasAttr = entry.get(this.aliasedObjectNameAT);
                    this.addAliasIndices(partitionTxn, id, dn, new Dn(this.schemaManager, aliasAttr.getString()));
                }
                if ((entryCsn = entry.get(this.entryCsnAT)) == null) {
                    String msg = I18n.err(I18n.ERR_219, dn, entry);
                    throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, msg);
                }
                this.entryCsnIdx.add(partitionTxn, entryCsn.getString(), id);
                if (entry.containsAttribute(this.administrativeRoleAT)) {
                    Attribute adminRoles = entry.get(this.administrativeRoleAT);
                    for (Value value : adminRoles) {
                        this.adminRoleIdx.add(partitionTxn, value.getValue(), id);
                    }
                    this.presenceIdx.add(partitionTxn, this.administrativeRoleAT.getOid(), id);
                }
                for (Attribute attribute : entry) {
                    AttributeType attributeType = attribute.getAttributeType();
                    String attributeOid = attributeType.getOid();
                    if (!this.hasUserIndexOn(attributeType)) continue;
                    Index<?, String> idx = this.getUserIndex(attributeType);
                    for (Value value : attribute) {
                        idx.add(partitionTxn, value.getValue(), id);
                    }
                    this.presenceIdx.add(partitionTxn, attributeOid, id);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exiting after fetching entries " + repaired);
            throw new LdapOtherException(e.getMessage(), e);
        }
        finally {
            cursor.close();
        }
        return masterTableCount;
    }

    private void updateRdnIndexCounters(PartitionTxn partitionTxn) throws LdapException, IOException {
        System.out.println("Updating the RDN index counters...");
        try (Cursor cursor = this.getMasterTable().cursor();){
            while (cursor.next()) {
                Tuple tuple = cursor.get();
                Entry entry = (Entry)tuple.getValue();
                String parentId = entry.get("1.3.6.1.4.1.18060.0.4.1.2.51").getString();
                if (parentId == Partition.ROOT_ID) continue;
                this.updateRdnIdx(partitionTxn, parentId, true, 0);
            }
        }
    }

    @Override
    protected void doRepair() throws LdapException {
        BaseRecordManager base;
        try {
            base = new BaseRecordManager(this.getPartitionPath().getPath());
            TransactionManager transactionManager = base.getTransactionManager();
            transactionManager.setMaximumTransactionsInLog(2000);
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), ioe);
        }
        File partitionDir = new File(this.getPartitionPath());
        List<String> indexDbFileNameList = Arrays.asList(partitionDir.list(DB_FILTER));
        ArrayList<String> allIndices = new ArrayList<String>();
        try {
            for (Index<?, String> index : this.getIndexedAttributes()) {
                AttributeType indexAT = this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId());
                String oid = indexAT.getOid();
                allIndices.add(oid);
                String name = oid + JDBM_DB_FILE_EXTN;
                if (!indexDbFileNameList.contains(name)) continue;
                ((JdbmIndex)index).close(null);
                File indexFile = new File(partitionDir, name);
                indexFile.delete();
                ((JdbmIndex)index).init(base, this.schemaManager, indexAT);
            }
            int masterTableCount = this.rebuildIndexes(null);
            this.updateRdnIndexCounters(null);
            this.sync();
            System.out.println("Total entries present in the partition " + masterTableCount);
            System.out.println("Repair complete");
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), ioe);
        }
    }

    @Override
    protected void doInit() throws LdapException {
        if (!this.initialized) {
            if (!this.optimizerEnabled) {
                this.setOptimizer(new NoOpOptimizer());
            } else {
                this.setOptimizer(new DefaultOptimizer(this));
            }
            EvaluatorBuilder evaluatorBuilder = new EvaluatorBuilder(this, this.schemaManager);
            CursorBuilder cursorBuilder = new CursorBuilder(this, evaluatorBuilder);
            this.setSearchEngine(new DefaultSearchEngine(this, cursorBuilder, evaluatorBuilder, this.getOptimizer()));
            File partitionDir = new File(this.getPartitionPath());
            if (!partitionDir.exists() && !partitionDir.mkdirs()) {
                throw new LdapOtherException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECTORY, partitionDir));
            }
            String path = partitionDir.getPath() + File.separator + this.id;
            try {
                BaseRecordManager base = new BaseRecordManager(path);
                TransactionManager transactionManager = base.getTransactionManager();
                transactionManager.setMaximumTransactionsInLog(2000);
                String cacheSizeVal = System.getProperty("jdbm.recman.cache.size", "100");
                int recCacheSize = Integer.parseInt(cacheSizeVal);
                LOG.info("Setting CacheRecondManager's cache size to {}", (Object)recCacheSize);
                this.recMan = new CacheRecordManager(base, new MRU<Long, CacheRecordManager.CacheEntry>(recCacheSize));
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), ioe);
            }
            ArrayList<String> allIndices = new ArrayList<String>();
            ArrayList indexToBuild = new ArrayList();
            for (Index<?, String> index : this.getIndexedAttributes()) {
                String oid = this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId()).getOid();
                allIndices.add(oid);
                try {
                    String forwardIndex = oid + "_forward";
                    if (this.recMan.getNamedObject(forwardIndex) != 0L) continue;
                    indexToBuild.add(index);
                }
                catch (IOException ioe) {
                    throw new LdapOtherException(ioe.getMessage(), ioe);
                }
            }
            super.doInit();
            if (this.cacheSize < 0) {
                this.cacheSize = 10000;
                LOG.debug("Using the default entry cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
            } else {
                LOG.debug("Using the custom configured cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
            }
            try {
                this.master = new JdbmMasterTable(this.recMan, this.schemaManager);
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), ioe);
            }
            if (!indexToBuild.isEmpty()) {
                this.buildUserIndex(this.beginReadTransaction(), indexToBuild);
            }
            if (this.cacheService != null) {
                this.entryCache = this.cacheService.getCache(this.getId());
                int cacheSizeConfig = (int)this.entryCache.getCacheConfiguration().getMaxEntriesLocalHeap();
                if (cacheSizeConfig < this.cacheSize) {
                    this.entryCache.getCacheConfiguration().setMaxEntriesLocalHeap(this.cacheSize);
                }
            }
            if (this.suffixDn != null && this.contextEntry != null) {
                Dn contextEntryDn = this.contextEntry.getDn();
                if (!contextEntryDn.isSchemaAware()) {
                    contextEntryDn = new Dn(this.schemaManager, contextEntryDn);
                }
                if (this.suffixDn.equals(contextEntryDn)) {
                    Entry suffixEntry;
                    PartitionTxn partitionTxn;
                    LookupOperationContext lookupContext = new LookupOperationContext(null, this.suffixDn);
                    lookupContext.setPartition(this);
                    try {
                        partitionTxn = this.beginReadTransaction();
                        Throwable throwable = null;
                        try {
                            lookupContext.setTransaction(partitionTxn);
                            suffixEntry = this.lookup(lookupContext);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (partitionTxn != null) {
                                if (throwable != null) {
                                    try {
                                        partitionTxn.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    partitionTxn.close();
                                }
                            }
                        }
                    }
                    catch (IOException ioe) {
                        throw new LdapOtherException(ioe.getMessage(), ioe);
                    }
                    if (suffixEntry == null) {
                        if (!this.contextEntry.isSchemaAware()) {
                            this.contextEntry = new DefaultEntry(this.schemaManager, this.contextEntry);
                        }
                        if (this.contextEntry.get("entryCSN") == null) {
                            this.contextEntry.add("entryCSN", new CsnFactory(0).newInstance().toString());
                        }
                        if (this.contextEntry.get("entryUUID") == null) {
                            String uuid = UUID.randomUUID().toString();
                            this.contextEntry.add("entryUUID", uuid);
                        }
                        partitionTxn = null;
                        AddOperationContext addContext = new AddOperationContext(null, this.contextEntry);
                        try {
                            partitionTxn = this.beginWriteTransaction();
                            addContext.setTransaction(partitionTxn);
                            this.add(addContext);
                            partitionTxn.commit();
                        }
                        catch (LdapException le) {
                            if (partitionTxn != null) {
                                try {
                                    partitionTxn.abort();
                                }
                                catch (IOException ioe) {
                                    throw new LdapOtherException(ioe.getMessage(), ioe);
                                }
                            }
                            throw le;
                        }
                        catch (IOException ioe) {
                            try {
                                partitionTxn.abort();
                            }
                            catch (IOException ioe2) {
                                throw new LdapOtherException(ioe2.getMessage(), ioe2);
                            }
                            throw new LdapOtherException(ioe.getMessage(), ioe);
                        }
                    }
                }
            }
            this.initialized = true;
        }
    }

    public String getDefaultId() {
        return Partition.DEFAULT_ID;
    }

    public String getRootId() {
        return Partition.ROOT_ID;
    }

    @Override
    public synchronized void sync() throws LdapException {
        if (!this.initialized) {
            return;
        }
        try {
            this.recMan.commit();
            BaseRecordManager baseRecordManager = null;
            baseRecordManager = this.recMan instanceof CacheRecordManager ? (BaseRecordManager)((CacheRecordManager)this.recMan).getRecordManager() : (BaseRecordManager)this.recMan;
            baseRecordManager.getTransactionManager().synchronizeLog();
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), ioe);
        }
    }

    private void buildUserIndex(PartitionTxn partitionTxn, List<Index<?, String>> indices) throws LdapException {
        try {
            Cursor cursor = this.master.cursor();
            cursor.beforeFirst();
            while (cursor.next()) {
                for (Index<?, String> index : indices) {
                    AttributeType atType = index.getAttribute();
                    String attributeOid = index.getAttribute().getOid();
                    if (this.systemIndices.get(attributeOid) != null) continue;
                    LOG.info("building the index for attribute type {}", (Object)atType);
                    Tuple tuple = cursor.get();
                    String id = (String)tuple.getKey();
                    Entry entry = (Entry)tuple.getValue();
                    Attribute entryAttr = entry.get(atType);
                    if (entryAttr == null) continue;
                    for (Value value : entryAttr) {
                        index.add(partitionTxn, value.getValue(), id);
                    }
                    this.presenceIdx.add(partitionTxn, attributeOid, id);
                }
            }
            cursor.close();
        }
        catch (IOException | CursorException e) {
            throw new LdapOtherException(e.getMessage(), e);
        }
    }

    private void deleteUnusedIndexFiles(List<String> allIndices, File[] dbFiles) {
        for (File file : dbFiles) {
            String name = file.getName();
            if (this.systemIndices.get(name = name.substring(0, name.lastIndexOf(JDBM_DB_FILE_EXTN))) != null || allIndices.contains(name)) continue;
            boolean deleted = file.delete();
            if (deleted) {
                LOG.info("Deleted unused index file {}", (Object)file.getAbsolutePath());
                continue;
            }
            LOG.warn("Failed to delete unused index file {}", (Object)file.getAbsolutePath());
        }
    }

    @Override
    protected Index<?, String> convertAndInit(Index<?, String> index) throws LdapException {
        JdbmIndex jdbmIndex;
        if (index instanceof JdbmRdnIndex) {
            jdbmIndex = (JdbmRdnIndex)index;
        } else if (index instanceof JdbmDnIndex) {
            jdbmIndex = (JdbmDnIndex)index;
        } else if (index instanceof JdbmIndex) {
            jdbmIndex = (JdbmIndex)index;
        } else {
            LOG.debug("Supplied index {} is not a JdbmIndex.  Will create new JdbmIndex using copied configuration parameters.", (Object)index);
            jdbmIndex = new JdbmIndex(index.getAttributeId(), true);
            jdbmIndex.setCacheSize(index.getCacheSize());
            jdbmIndex.setNumDupLimit(512);
        }
        try {
            jdbmIndex.init(this.recMan, this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId()));
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), ioe);
        }
        return jdbmIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void doDestroy(PartitionTxn partitionTxn) throws LdapException {
        MultiException errors = new MultiException(I18n.err(I18n.ERR_577, new Object[0]));
        if (!this.initialized) {
            return;
        }
        try {
            super.doDestroy(partitionTxn);
        }
        catch (Exception e) {
            errors.addThrowable(e);
        }
        try {
            this.recMan.close();
            LOG.debug("Closed record manager for {} partition.", (Object)this.suffixDn);
        }
        catch (IOException t) {
            LOG.error(I18n.err(I18n.ERR_127, new Object[0]), t);
            errors.addThrowable(t);
        }
        finally {
            if (this.entryCache != null) {
                this.entryCache.removeAll();
            }
        }
        if (errors.size() > 0) {
            throw new LdapOtherException(errors.getMessage(), errors);
        }
    }

    @Override
    protected final Index createSystemIndex(String oid, URI path, boolean withReverse) throws LdapException {
        JdbmIndex jdbmIndex;
        LOG.debug("Supplied index {} is not a JdbmIndex.  Will create new JdbmIndex using copied configuration parameters.");
        if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
            jdbmIndex = new JdbmRdnIndex();
            jdbmIndex.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.50");
            jdbmIndex.setNumDupLimit(512);
        } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
            jdbmIndex = new JdbmDnIndex("1.3.6.1.4.1.18060.0.4.1.2.7");
            jdbmIndex.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.7");
            jdbmIndex.setNumDupLimit(512);
        } else {
            jdbmIndex = new JdbmIndex(oid, withReverse);
            jdbmIndex.setNumDupLimit(512);
        }
        jdbmIndex.setWkDirPath(path);
        return jdbmIndex;
    }

    @Override
    public void updateCache(OperationContext opCtx) {
        if (this.entryCache == null) {
            return;
        }
        try {
            if (opCtx instanceof ModifyOperationContext) {
                ModifyOperationContext modCtx = (ModifyOperationContext)opCtx;
                Entry entry = modCtx.getAlteredEntry();
                String id = entry.get("entryUUID").getString();
                if (entry instanceof ClonedServerEntry) {
                    entry = ((ClonedServerEntry)entry).getOriginalEntry();
                }
                this.entryCache.replace(new Element((Serializable)((Object)id), entry));
            } else if (opCtx instanceof MoveOperationContext || opCtx instanceof MoveAndRenameOperationContext || opCtx instanceof RenameOperationContext) {
                this.entryCache.removeAll();
            } else if (opCtx instanceof DeleteOperationContext) {
                DeleteOperationContext delCtx = (DeleteOperationContext)opCtx;
                this.entryCache.remove((Serializable)((Object)delCtx.getEntry().get("entryUUID").getString()));
            }
        }
        catch (LdapException e) {
            LOG.warn("Failed to update entry cache", e);
        }
    }

    @Override
    public Entry lookupCache(String id) {
        if (this.entryCache == null) {
            return null;
        }
        Element el = this.entryCache.get((Serializable)((Object)id));
        if (el != null) {
            return (Entry)el.getObjectValue();
        }
        return null;
    }

    @Override
    public void addToCache(String id, Entry entry) {
        if (this.entryCache == null) {
            return;
        }
        Entry addedEntry = entry;
        if (entry instanceof ClonedServerEntry) {
            addedEntry = ((ClonedServerEntry)entry).getOriginalEntry();
        }
        this.entryCache.put(new Element((Serializable)((Object)id), addedEntry));
    }

    @Override
    public PartitionReadTxn beginReadTransaction() {
        return new PartitionReadTxn();
    }

    @Override
    public PartitionWriteTxn beginWriteTransaction() {
        return new JdbmPartitionWriteTxn(this.recMan, this.isSyncOnWrite());
    }
}

