/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.IOException;
import jdbm.RecordManager;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.UuidComparator;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DnSerializer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DnSerializerComparator;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.UuidSerializer;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbmDnIndex
extends JdbmIndex<Dn> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmDnIndex.class);

    public JdbmDnIndex(String oid) {
        super(oid, true);
        this.initialized = false;
    }

    @Override
    public void init(RecordManager recMan, SchemaManager schemaManager, AttributeType attributeType) throws LdapException, IOException {
        LOG.debug("Initializing an Index for attribute '{}'", (Object)attributeType.getName());
        this.attributeType = attributeType;
        if (this.attributeId == null) {
            this.setAttributeId(attributeType.getName());
        }
        if (this.wkDirPath == null) {
            NullPointerException e = new NullPointerException("The index working directory has not be set");
            throw e;
        }
        String path = new File(this.wkDirPath, attributeType.getOid()).getAbsolutePath();
        this.recMan = recMan;
        try {
            this.initTables(schemaManager);
        }
        catch (IOException e) {
            this.close(null);
            throw e;
        }
        this.initialized = true;
    }

    private void initTables(SchemaManager schemaManager) throws IOException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            throw new IOException(I18n.err(I18n.ERR_574, this.attributeType.getName()));
        }
        DnSerializerComparator comp = new DnSerializerComparator(mr.getOid());
        UuidComparator.INSTANCE.setSchemaManager(schemaManager);
        DnSerializer dnSerializer = new DnSerializer(schemaManager);
        this.forward = new JdbmTable(schemaManager, this.attributeType.getOid() + "_forward", this.recMan, comp, dnSerializer, UuidSerializer.INSTANCE);
        this.reverse = new JdbmTable(schemaManager, this.attributeType.getOid() + "_reverse", this.recMan, UuidComparator.INSTANCE, UuidSerializer.INSTANCE, dnSerializer);
    }
}

