/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.event;

import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidSearchFilterException;
import org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ExtensibleNode;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.apache.directory.server.core.api.event.Evaluator;
import org.apache.directory.server.core.api.event.ScopeEvaluator;
import org.apache.directory.server.core.api.event.SubstringEvaluator;
import org.apache.directory.server.i18n.I18n;

public class LeafEvaluator
implements Evaluator {
    private static final int EQUALITY_MATCH = 0;
    private static final int ORDERING_MATCH = 1;
    private static final int SUBSTRING_MATCH = 3;
    private SubstringEvaluator substringEvaluator;
    private ScopeEvaluator scopeEvaluator = new ScopeEvaluator();
    private static final boolean COMPARE_GREATER = true;
    private static final boolean COMPARE_LESSER = false;

    public LeafEvaluator(SubstringEvaluator substringEvaluator) {
        this.substringEvaluator = substringEvaluator;
    }

    public ScopeEvaluator getScopeEvaluator() {
        return this.scopeEvaluator;
    }

    public SubstringEvaluator getSubstringEvaluator() {
        return this.substringEvaluator;
    }

    @Override
    public boolean evaluate(ExprNode node, Dn dn, Entry entry) throws LdapException {
        if (node instanceof ScopeNode) {
            return this.scopeEvaluator.evaluate(node, dn, entry);
        }
        if (node instanceof PresenceNode) {
            return this.evalPresence(((PresenceNode)node).getAttributeType(), entry);
        }
        if (node instanceof EqualityNode || node instanceof ApproximateNode) {
            return this.evalEquality((EqualityNode)node, entry);
        }
        if (node instanceof GreaterEqNode) {
            return this.evalGreaterOrLesser((GreaterEqNode)node, entry, true);
        }
        if (node instanceof LessEqNode) {
            return this.evalGreaterOrLesser((LessEqNode)node, entry, false);
        }
        if (node instanceof SubstringNode) {
            return this.substringEvaluator.evaluate(node, dn, entry);
        }
        if (node instanceof ExtensibleNode) {
            throw new NotImplementedException();
        }
        throw new LdapInvalidSearchFilterException(I18n.err(I18n.ERR_245, node));
    }

    private boolean evalGreaterOrLesser(SimpleNode<?> node, Entry entry, boolean isGreaterOrLesser) throws LdapException {
        AttributeType attributeType = node.getAttributeType();
        Attribute attr = entry.get(node.getAttribute());
        if (null == attr) {
            return false;
        }
        Normalizer normalizer = this.getNormalizer(attributeType);
        Value filterValue = node.getValue();
        if (isGreaterOrLesser) {
            for (Value value : attr) {
                if (value.compareTo(filterValue) < 0) continue;
                return true;
            }
        } else {
            for (Value value : attr) {
                if (value.compareTo(filterValue) > 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evalPresence(AttributeType attributeType, Entry entry) throws LdapException {
        if (entry == null) {
            return false;
        }
        return null != entry.get(attributeType);
    }

    private boolean evalEquality(EqualityNode<?> node, Entry entry) throws LdapException {
        Normalizer normalizer = this.getNormalizer(node.getAttributeType());
        LdapComparator<? super Object> comparator = this.getComparator(node.getAttributeType());
        Attribute attr = entry.get(node.getAttribute());
        if (null == attr) {
            return false;
        }
        AttributeType attributeType = node.getAttributeType();
        Value value = null;
        value = attributeType.getSyntax().isHumanReadable() ? (node.getValue().isHumanReadable() ? node.getValue() : new Value(attributeType, node.getValue().getValue())) : node.getValue();
        if (attr.contains(value)) {
            return true;
        }
        if (attr.contains(value)) {
            return true;
        }
        for (Value val : attr) {
            if (0 != val.compareTo(value)) continue;
            return true;
        }
        return false;
    }

    private LdapComparator<? super Object> getComparator(AttributeType attributeType) throws LdapException {
        MatchingRule mrule = this.getMatchingRule(attributeType, 0);
        return mrule.getLdapComparator();
    }

    private Normalizer getNormalizer(AttributeType attributeType) throws LdapException {
        MatchingRule mrule = this.getMatchingRule(attributeType, 0);
        return mrule.getNormalizer();
    }

    private MatchingRule getMatchingRule(AttributeType attributeType, int matchType) throws LdapException {
        MatchingRule mrule = null;
        switch (matchType) {
            case 0: {
                mrule = attributeType.getEquality();
                break;
            }
            case 3: {
                mrule = attributeType.getSubstring();
                break;
            }
            case 1: {
                mrule = attributeType.getOrdering();
                break;
            }
            default: {
                throw new LdapException(I18n.err(I18n.ERR_246, matchType));
            }
        }
        if (mrule == null && matchType != 0) {
            mrule = attributeType.getEquality();
        }
        return mrule;
    }
}

