/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsnComparator
extends LdapComparator<Object> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(CsnComparator.class);

    public CsnComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(Object csnObj1, Object csnObj2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13745_COMPARING_CSN, csnObj1, csnObj2));
        }
        if (csnObj1 == csnObj2) {
            return 0;
        }
        if (csnObj1 == null) {
            return -1;
        }
        if (csnObj2 == null) {
            return 1;
        }
        String csnStr1 = csnObj1 instanceof Value ? ((Value)csnObj1).getValue() : csnObj1.toString();
        String csnStr2 = csnObj2 instanceof Value ? ((Value)csnObj2).getValue() : csnObj2.toString();
        return csnStr1.compareTo(csnStr2);
    }
}

