/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObjectRenderer;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;

public class NameForm
extends AbstractSchemaObject {
    public static final long serialVersionUID = 1L;
    private String structuralObjectClassOid;
    private ObjectClass structuralObjectClass;
    private List<String> mustAttributeTypeOids = new ArrayList<String>();
    private List<AttributeType> mustAttributeTypes;
    private List<String> mayAttributeTypeOids = new ArrayList<String>();
    private List<AttributeType> mayAttributeTypes;

    public NameForm(String oid) {
        super(SchemaObjectType.NAME_FORM, oid);
        this.mustAttributeTypes = new ArrayList<AttributeType>();
        this.mayAttributeTypes = new ArrayList<AttributeType>();
    }

    public String getStructuralObjectClassOid() {
        return this.structuralObjectClassOid;
    }

    public ObjectClass getStructuralObjectClass() {
        return this.structuralObjectClass;
    }

    public void setStructuralObjectClassOid(String structuralObjectClassOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        if (!this.isReadOnly) {
            this.structuralObjectClassOid = structuralObjectClassOid;
        }
    }

    public void setStructuralObjectClass(ObjectClass structuralObjectClass) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        if (!this.isReadOnly) {
            this.structuralObjectClass = structuralObjectClass;
            this.structuralObjectClassOid = structuralObjectClass.getOid();
        }
    }

    public List<String> getMustAttributeTypeOids() {
        return Collections.unmodifiableList(this.mustAttributeTypeOids);
    }

    public List<AttributeType> getMustAttributeTypes() {
        return Collections.unmodifiableList(this.mustAttributeTypes);
    }

    public void setMustAttributeTypeOids(List<String> mustAttributeTypeOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        if (!this.isReadOnly) {
            this.mustAttributeTypeOids = mustAttributeTypeOids;
        }
    }

    public void setMustAttributeTypes(List<AttributeType> mustAttributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        if (!this.isReadOnly) {
            this.mustAttributeTypes = mustAttributeTypes;
            this.mustAttributeTypeOids.clear();
            for (AttributeType may : mustAttributeTypes) {
                this.mustAttributeTypeOids.add(may.getOid());
            }
        }
    }

    public void addMustAttributeTypeOids(String oid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        if (!this.isReadOnly) {
            this.mustAttributeTypeOids.add(oid);
        }
    }

    public void addMustAttributeTypes(AttributeType attributeType) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        if (!this.isReadOnly && !this.mustAttributeTypeOids.contains(attributeType.getOid())) {
            this.mustAttributeTypes.add(attributeType);
            this.mustAttributeTypeOids.add(attributeType.getOid());
        }
    }

    public List<String> getMayAttributeTypeOids() {
        return Collections.unmodifiableList(this.mayAttributeTypeOids);
    }

    public List<AttributeType> getMayAttributeTypes() {
        return Collections.unmodifiableList(this.mayAttributeTypes);
    }

    public void setMayAttributeTypeOids(List<String> mayAttributeTypeOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        if (!this.isReadOnly) {
            this.mayAttributeTypeOids = mayAttributeTypeOids;
        }
    }

    public void setMayAttributeTypes(List<AttributeType> mayAttributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        if (!this.isReadOnly) {
            this.mayAttributeTypes = mayAttributeTypes;
            this.mayAttributeTypeOids.clear();
            for (AttributeType may : mayAttributeTypes) {
                this.mayAttributeTypeOids.add(may.getOid());
            }
        }
    }

    public void addMayAttributeTypeOids(String oid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        if (!this.isReadOnly) {
            this.mayAttributeTypeOids.add(oid);
        }
    }

    public void addMayAttributeTypes(AttributeType attributeType) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        if (!this.isReadOnly && !this.mayAttributeTypeOids.contains(attributeType.getOid())) {
            this.mayAttributeTypes.add(attributeType);
            this.mayAttributeTypeOids.add(attributeType.getOid());
        }
    }

    public String toString() {
        return SchemaObjectRenderer.OPEN_LDAP_SCHEMA_RENDERER.render(this);
    }

    @Override
    public NameForm copy() {
        NameForm copy = new NameForm(this.oid);
        copy.copy(this);
        copy.mayAttributeTypeOids = new ArrayList<String>();
        for (String oid : this.mayAttributeTypeOids) {
            copy.mayAttributeTypeOids.add(oid);
        }
        copy.mayAttributeTypes = new ArrayList<AttributeType>();
        copy.mustAttributeTypeOids = new ArrayList<String>();
        for (String oid : this.mustAttributeTypeOids) {
            copy.mustAttributeTypeOids.add(oid);
        }
        copy.mustAttributeTypes = new ArrayList<AttributeType>();
        copy.structuralObjectClassOid = this.structuralObjectClassOid;
        copy.structuralObjectClass = null;
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof NameForm)) {
            return false;
        }
        NameForm that = (NameForm)o;
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.mayAttributeTypes.clear();
        this.mayAttributeTypeOids.clear();
        this.mustAttributeTypes.clear();
        this.mustAttributeTypeOids.clear();
        this.structuralObjectClass = null;
    }
}

