/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapEncoder;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.SearchResultReference;

public class SearchResultReferenceDecorator
extends MessageDecorator<SearchResultReference>
implements SearchResultReference {
    private int searchResultReferenceLength;

    public SearchResultReferenceDecorator(LdapApiService codec, SearchResultReference decoratedMessage) {
        super(codec, decoratedMessage);
    }

    @Override
    public Referral getReferral() {
        return ((SearchResultReference)this.getDecorated()).getReferral();
    }

    @Override
    public void setReferral(Referral referral) {
        ((SearchResultReference)this.getDecorated()).setReferral(referral);
    }

    @Override
    public int computeLength() {
        this.searchResultReferenceLength = 0;
        Referral referral = this.getReferral();
        int referralLength = LdapEncoder.computeReferralLength(referral);
        if (referralLength != 0) {
            this.setReferral(referral);
            this.searchResultReferenceLength = referralLength;
        }
        return 1 + TLV.getNbBytes(this.searchResultReferenceLength) + this.searchResultReferenceLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        SearchResultReference searchResultReference = (SearchResultReference)this.getDecorated();
        try {
            buffer.put((byte)115);
            buffer.put(TLV.getBytes(this.searchResultReferenceLength));
            Referral referral = searchResultReference.getReferral();
            if (referral != null) {
                for (byte[] ldapUrlBytes : referral.getLdapUrlsBytes()) {
                    BerValue.encode(buffer, ldapUrlBytes);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, new Object[0]), boe);
        }
        return buffer;
    }
}

