/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.api.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;

public class ModifyDnResponseDecorator
extends ResponseDecorator<ModifyDnResponse>
implements ModifyDnResponse {
    private int modifyDnResponseLength;

    public ModifyDnResponseDecorator(LdapApiService codec, ModifyDnResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    @Override
    public int computeLength() {
        this.modifyDnResponseLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        return 1 + TLV.getNbBytes(this.modifyDnResponseLength) + this.modifyDnResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)109);
            buffer.put(TLV.getBytes(this.modifyDnResponseLength));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, new Object[0]), boe);
        }
        return buffer;
    }
}

