/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWriteSerializationCopyStrategy
implements ReadWriteCopyStrategy<Element> {
    @Override
    public Element copyForWrite(Element value) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        if (value.getObjectValue() == null) {
            return this.duplicateElementWithNewValue(value, null);
        }
        try {
            oos = new ObjectOutputStream(bout);
            oos.writeObject(value.getObjectValue());
        }
        catch (Exception e) {
            throw new CacheException("When configured copyOnRead or copyOnWrite, a Store will only accept Serializable values", e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {}
        }
        return this.duplicateElementWithNewValue(value, bout.toByteArray());
    }

    @Override
    public Element copyForRead(Element storedValue) {
        if (storedValue == null) {
            return null;
        }
        if (storedValue.getObjectValue() == null) {
            return this.duplicateElementWithNewValue(storedValue, null);
        }
        ByteArrayInputStream bin = new ByteArrayInputStream((byte[])storedValue.getObjectValue());
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bin);
            Element element = this.duplicateElementWithNewValue(storedValue, ois.readObject());
            return element;
        }
        catch (Exception e) {
            throw new CacheException("When configured copyOnRead or copyOnWrite, a Store will only accept Serializable values", e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Element duplicateElementWithNewValue(Element element, Object newValue) {
        return new Element(element.getObjectKey(), newValue, element.getVersion(), element.getCreationTime(), element.getLastAccessTime(), element.getHitCount(), element.usesCacheDefaultLifespan(), element.getTimeToLive(), element.getTimeToIdle(), element.getLastUpdateTime());
    }
}

