/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.searchResultEntry;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchResultEntryDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreSearchResultEntryObjectName
extends GrammarAction<LdapMessageContainer<SearchResultEntryDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchResultEntryObjectName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreSearchResultEntryObjectName() {
        super("Store SearchResultEntry name");
    }

    @Override
    public void action(LdapMessageContainer<SearchResultEntryDecorator> container) throws DecoderException {
        SearchResultEntryDecorator searchResultEntry = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Dn objectName = Dn.EMPTY_DN;
        if (tlv.getLength() == 0) {
            searchResultEntry.setObjectName(objectName);
        } else {
            byte[] dnBytes = tlv.getValue().getData();
            String dnStr = Strings.utf8ToString(dnBytes);
            try {
                objectName = new Dn(dnStr);
            }
            catch (LdapInvalidDnException ine) {
                String msg = "The Dn " + Strings.dumpBytes(dnBytes) + "is invalid : " + ine.getMessage();
                LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                throw new DecoderException(msg, ine);
            }
            searchResultEntry.setObjectName(objectName);
        }
        if (IS_DEBUG) {
            LOG.debug("Search Result Entry Dn found : {}", (Object)searchResultEntry.getObjectName());
        }
    }
}

