/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.BerValue;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReadInteger<E extends Asn1Container>
extends GrammarAction<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadInteger.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private int minValue = 0;
    private int maxValue = Integer.MAX_VALUE;

    public AbstractReadInteger(String name) {
        super(name);
    }

    public AbstractReadInteger(String name, int minValue, int maxValue) {
        super(name);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    protected abstract void setIntegerValue(int var1, E var2);

    @Override
    public final void action(E container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err(I18n.ERR_04066, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_04067, new Object[0]));
        }
        BerValue value = tlv.getValue();
        try {
            int number = IntegerDecoder.parse(value, this.minValue, this.maxValue);
            if (IS_DEBUG) {
                LOG.debug("read integer value : {}", (Object)number);
            }
            this.setIntegerValue(number, container);
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err(I18n.ERR_04070, Strings.dumpBytes(value.getData()), ide.getLocalizedMessage()));
            throw new DecoderException(ide.getMessage(), ide);
        }
    }
}

