/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search;

import java.util.Set;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.model.cursor.SetCursor;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class PartitionSearchResult {
    private SetCursor<IndexEntry<String, String>> resultSet;
    private Set<String> candidateSet;
    private AliasDerefMode aliasDerefMode = AliasDerefMode.NEVER_DEREF_ALIASES;
    private Evaluator<? extends ExprNode> evaluator;
    private SchemaManager schemaManager;

    public PartitionSearchResult(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public SetCursor<IndexEntry<String, String>> getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(Set<IndexEntry<String, String>> set) {
        this.resultSet = new SetCursor<IndexEntry<String, String>>(set);
    }

    public Set<String> getCandidateSet() {
        return this.candidateSet;
    }

    public void setCandidateSet(Set<String> set) {
        this.candidateSet = set;
    }

    public Evaluator<? extends ExprNode> getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(Evaluator<? extends ExprNode> evaluator) {
        this.evaluator = evaluator;
    }

    public void setAliasDerefMode(AliasDerefMode aliasDerefMode) {
        this.aliasDerefMode = aliasDerefMode;
    }

    public boolean isNeverDeref() {
        return this.aliasDerefMode == AliasDerefMode.NEVER_DEREF_ALIASES;
    }

    public boolean isDerefAlways() {
        return this.aliasDerefMode == AliasDerefMode.DEREF_ALWAYS;
    }

    public boolean isDerefInSearching() {
        return this.aliasDerefMode == AliasDerefMode.DEREF_IN_SEARCHING;
    }

    public boolean isDerefFinding() {
        return this.aliasDerefMode == AliasDerefMode.DEREF_FINDING_BASE_OBJ;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search result : \n");
        sb.append("Alias : ").append((Object)this.aliasDerefMode).append("\n");
        sb.append("Evaluator : ").append(this.evaluator).append("\n");
        if (this.resultSet == null) {
            sb.append("No UUID found");
        } else {
            sb.append('{');
            boolean isFirst = true;
            try {
                while (this.resultSet.next()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(this.resultSet.get().getId());
                }
                this.resultSet.beforeFirst();
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append('}');
        }
        return sb.toString();
    }
}

