/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.core.security.CoreKeyStoreSpi;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapProtocolHandler;
import org.apache.directory.server.ldap.LdapSessionManager;
import org.apache.directory.server.ldap.handlers.AbandonHandler;
import org.apache.directory.server.ldap.handlers.AddHandler;
import org.apache.directory.server.ldap.handlers.BindHandler;
import org.apache.directory.server.ldap.handlers.CompareHandler;
import org.apache.directory.server.ldap.handlers.DeleteHandler;
import org.apache.directory.server.ldap.handlers.ExtendedHandler;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.server.ldap.handlers.ModifyDnHandler;
import org.apache.directory.server.ldap.handlers.ModifyHandler;
import org.apache.directory.server.ldap.handlers.SearchHandler;
import org.apache.directory.server.ldap.handlers.UnbindHandler;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.ldap.handlers.ssl.LdapsInitializer;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumer;
import org.apache.directory.server.ldap.replication.provider.ReplicationRequestHandler;
import org.apache.directory.server.protocol.shared.DirectoryBackedService;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.shared.ldap.model.constants.SaslQoP;
import org.apache.directory.shared.ldap.model.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.model.message.AbandonRequest;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.ExtendedRequest;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.UnbindRequest;
import org.apache.directory.shared.ldap.model.message.extended.NoticeOfDisconnect;
import org.apache.directory.shared.util.Strings;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.executor.UnorderedThreadPoolExecutor;
import org.apache.mina.handler.demux.MessageHandler;
import org.apache.mina.transport.socket.AbstractSocketSessionConfig;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapServer
extends DirectoryBackedService {
    private static final long serialVersionUID = 3757127143811666817L;
    private static final Logger LOG = LoggerFactory.getLogger(LdapServer.class.getName());
    public static final long NO_SIZE_LIMIT = 0L;
    public static final int NO_TIME_LIMIT = 0;
    public static final String SERVICE_NAME = "ldap";
    private static final long MAX_SIZE_LIMIT_DEFAULT = 100L;
    private static final int MAX_TIME_LIMIT_DEFAULT = 10000;
    private static final String SERVICE_PID_DEFAULT = "org.apache.directory.server.ldap";
    private static final String SERVICE_NAME_DEFAULT = "ApacheDS LDAP Service";
    private LdapSessionManager ldapSessionManager = new LdapSessionManager();
    private Set<String> supportedControls;
    private long maxSizeLimit = 100L;
    private int maxTimeLimit = 10000;
    private String keystoreFile;
    private String certificatePassword;
    private final Collection<ExtendedOperationHandler> extendedOperationHandlers = new ArrayList<ExtendedOperationHandler>();
    private Map<String, MechanismHandler> saslMechanismHandlers = new HashMap<String, MechanismHandler>();
    private String saslHost = "ldap.example.com";
    private String saslPrincipal = "ldap/ldap.example.com@EXAMPLE.COM";
    private Set<String> saslQop;
    private String saslQopString;
    private List<String> saslRealms;
    private LdapRequestHandler<AbandonRequest> abandonHandler;
    private LdapRequestHandler<AddRequest> addHandler;
    private LdapRequestHandler<BindRequest> bindHandler;
    private LdapRequestHandler<CompareRequest> compareHandler;
    private LdapRequestHandler<DeleteRequest> deleteHandler;
    private ExtendedHandler extendedHandler;
    private LdapRequestHandler<ModifyRequest> modifyHandler;
    private LdapRequestHandler<ModifyDnRequest> modifyDnHandler;
    private LdapRequestHandler<SearchRequest> searchHandler;
    private LdapRequestHandler<UnbindRequest> unbindHandler;
    private ProtocolCodecFactory codecFactory = LdapApiServiceFactory.getSingleton().getProtocolCodecFactory();
    private final LdapProtocolHandler handler = new LdapProtocolHandler(this);
    private boolean started;
    private boolean confidentialityRequired;
    private KeyStore keyStore = null;
    private List<IoFilterChainBuilder> chainBuilders = new ArrayList<IoFilterChainBuilder>();
    private ReplicationRequestHandler replicationReqHandler;
    private List<ReplicationConsumer> replConsumers;

    public LdapServer() {
        super.setEnabled(true);
        super.setServiceId(SERVICE_PID_DEFAULT);
        super.setServiceName(SERVICE_NAME_DEFAULT);
        this.saslQop = new HashSet<String>();
        this.saslQop.add(SaslQoP.AUTH.getValue());
        this.saslQop.add(SaslQoP.AUTH_INT.getValue());
        this.saslQop.add(SaslQoP.AUTH_CONF.getValue());
        this.saslQopString = SaslQoP.AUTH.getValue() + ',' + SaslQoP.AUTH_INT.getValue() + ',' + SaslQoP.AUTH_CONF.getValue();
        this.saslRealms = new ArrayList<String>();
        this.saslRealms.add("example.com");
        this.supportedControls = new HashSet<String>();
        this.supportedControls.add("2.16.840.1.113730.3.4.3");
        this.supportedControls.add("2.16.840.1.113730.3.4.7");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.10.1");
        this.supportedControls.add("2.16.840.1.113730.3.4.2");
        this.supportedControls.add("1.3.6.1.4.1.18060.0.0.1");
        this.supportedControls.add("1.2.840.113556.1.4.319");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.9.1.3");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.9.1.4");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.9.1.1");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.9.1.2");
    }

    private void installDefaultHandlers() {
        if (this.getAbandonHandler() == null) {
            this.setAbandonHandler(new AbandonHandler());
        }
        if (this.getAddHandler() == null) {
            this.setAddHandler(new AddHandler());
        }
        if (this.getBindHandler() == null) {
            BindHandler handler = new BindHandler();
            handler.setSaslMechanismHandlers(this.saslMechanismHandlers);
            this.setBindHandler(handler);
        }
        if (this.getCompareHandler() == null) {
            this.setCompareHandler(new CompareHandler());
        }
        if (this.getDeleteHandler() == null) {
            this.setDeleteHandler(new DeleteHandler());
        }
        if (this.getExtendedHandler() == null) {
            this.setExtendedHandler(new ExtendedHandler());
        }
        if (this.getModifyHandler() == null) {
            this.setModifyHandler(new ModifyHandler());
        }
        if (this.getModifyDnHandler() == null) {
            this.setModifyDnHandler(new ModifyDnHandler());
        }
        if (this.getSearchHandler() == null) {
            this.setSearchHandler(new SearchHandler());
        }
        if (this.getUnbindHandler() == null) {
            this.setUnbindHandler(new UnbindHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeyStore() throws Exception {
        if (Strings.isEmpty(this.keystoreFile)) {
            Provider provider = Security.getProvider("SUN");
            LOG.debug("provider = {}", (Object)provider);
            CoreKeyStoreSpi coreKeyStoreSpi = new CoreKeyStoreSpi(this.getDirectoryService());
            this.keyStore = new KeyStore(coreKeyStoreSpi, provider, "JKS"){};
            try {
                this.keyStore.load(null, null);
            }
            catch (Exception exception) {}
        } else {
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.keystoreFile);
                this.keyStore.load(fis, null);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
    }

    public void reloadSslContext() throws Exception {
        if (!this.started) {
            return;
        }
        LOG.info("reloading SSL context...");
        this.loadKeyStore();
        String sslFilterName = "sslFilter";
        for (IoFilterChainBuilder chainBuilder : this.chainBuilders) {
            DefaultIoFilterChainBuilder dfcb = (DefaultIoFilterChainBuilder)chainBuilder;
            if (!dfcb.contains(sslFilterName)) continue;
            DefaultIoFilterChainBuilder newChain = (DefaultIoFilterChainBuilder)LdapsInitializer.init(this.keyStore, this.certificatePassword);
            dfcb.replace(sslFilterName, newChain.get(sslFilterName));
            newChain = null;
        }
        StartTlsHandler handler = (StartTlsHandler)this.getExtendedOperationHandler("1.3.6.1.4.1.1466.20037");
        if (handler != null) {
            handler.setLdapServer(this);
        }
        LOG.info("reloaded SSL context successfully");
    }

    @Override
    public void start() throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        for (Transport transport : this.transports) {
            IoFilterChainBuilder chain;
            if (!(transport instanceof TcpTransport)) {
                LOG.warn("Cannot listen on an UDP transport : {}", (Object)transport);
                continue;
            }
            if (transport.isSSLEnabled()) {
                this.loadKeyStore();
                chain = LdapsInitializer.init(this.keyStore, this.certificatePassword);
            } else {
                chain = new DefaultIoFilterChainBuilder();
            }
            ((DefaultIoFilterChainBuilder)chain).addLast("codec", new ProtocolCodecFilter(this.getProtocolCodecFactory()));
            ((DefaultIoFilterChainBuilder)chain).addLast("executor", new ExecutorFilter(new UnorderedThreadPoolExecutor(transport.getNbThreads()), IoEventType.MESSAGE_RECEIVED));
            this.startNetwork(transport, chain);
        }
        this.installDefaultHandlers();
        PartitionNexus nexus = this.getDirectoryService().getPartitionNexus();
        for (ExtendedOperationHandler h : this.extendedOperationHandlers) {
            LOG.info("Added Extended Request Handler: " + h.getOid());
            h.setLdapServer(this);
            nexus.registerSupportedExtensions(h.getExtensionOids());
        }
        nexus.registerSupportedSaslMechanisms(this.saslMechanismHandlers.keySet());
        this.startReplicationProducer();
        this.startReplicationConsumers();
        this.started = true;
        LOG.info("Ldap service started.");
    }

    public void startReplicationProducer() {
        if (this.replicationReqHandler != null) {
            this.replicationReqHandler.start(this);
            ((SearchHandler)this.getSearchHandler()).setReplicationReqHandler(this.replicationReqHandler);
        }
    }

    @Override
    public void stop() {
        try {
            for (Transport transport : this.transports) {
                ArrayList<IoSession> sessions;
                if (!(transport instanceof TcpTransport)) continue;
                ArrayList<WriteFuture> writeFutures = new ArrayList<WriteFuture>();
                try {
                    sessions = new ArrayList<IoSession>(this.getSocketAcceptor(transport).getManagedSessions().values());
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Seems like the LDAP service (" + this.getPort() + ") has already been unbound.");
                    return;
                }
                this.getSocketAcceptor(transport).dispose();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Unbind of an LDAP service (" + this.getPort() + ") is complete.");
                    LOG.info("Sending notice of disconnect to existing clients sessions.");
                }
                if (sessions != null) {
                    for (IoSession session : sessions) {
                        writeFutures.add(session.write(NoticeOfDisconnect.UNAVAILABLE));
                    }
                }
                Iterator sessionIt = sessions.iterator();
                for (WriteFuture future : writeFutures) {
                    future.await(1000L);
                    ((IoSession)sessionIt.next()).close(true);
                }
                if (this.replicationReqHandler == null) continue;
                this.replicationReqHandler.stop();
            }
            this.stopConsumers();
        }
        catch (Exception e) {
            LOG.warn("Failed to sent NoD.", e);
        }
        this.started = false;
        LOG.info("Ldap service stopped.");
    }

    private void startNetwork(Transport transport, IoFilterChainBuilder chainBuilder) throws Exception {
        if (transport.getBackLog() < 0) {
            transport.setBackLog(50);
        }
        this.chainBuilders.add(chainBuilder);
        try {
            SocketAcceptor acceptor = this.getSocketAcceptor(transport);
            acceptor.setCloseOnDeactivation(false);
            acceptor.getSessionConfig().setTcpNoDelay(true);
            acceptor.setFilterChainBuilder(chainBuilder);
            acceptor.setHandler(this.getHandler());
            ((AbstractSocketSessionConfig)acceptor.getSessionConfig()).setReadBufferSize(65536);
            ((AbstractSocketSessionConfig)acceptor.getSessionConfig()).setSendBufferSize(65536);
            acceptor.bind();
            this.started = true;
            if (LOG.isInfoEnabled()) {
                LOG.info("Successful bind of an LDAP Service (" + transport.getPort() + ") is completed.");
            }
        }
        catch (IOException e) {
            String msg = I18n.err(I18n.ERR_171, transport.getPort());
            LdapConfigurationException lce = new LdapConfigurationException(msg);
            lce.setCause(e);
            LOG.error(msg, e);
            throw lce;
        }
    }

    public void startReplicationConsumers() throws Exception {
        if (this.replConsumers != null) {
            for (final ReplicationConsumer consumer : this.replConsumers) {
                Runnable consumerTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LOG.info("starting the replication consumer with config {}", (Object)consumer);
                            consumer.init(LdapServer.this.getDirectoryService());
                            consumer.start();
                        }
                        catch (Exception e) {
                            LOG.error("Failed to start the consumer with config {}", (Object)consumer);
                            throw new RuntimeException(e);
                        }
                    }
                };
                Thread consumerThread = new Thread(consumerTask);
                consumerThread.setDaemon(true);
                consumerThread.start();
            }
        }
    }

    private void stopConsumers() {
        if (this.replConsumers != null) {
            for (ReplicationConsumer consumer : this.replConsumers) {
                LOG.info("stopping the consumer with id {}", (Object)consumer.getId());
                consumer.stop();
            }
        }
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    public LdapSessionManager getLdapSessionManager() {
        return this.ldapSessionManager;
    }

    public ProtocolCodecFactory getProtocolCodecFactory() {
        return this.codecFactory;
    }

    public void addExtendedOperationHandler(ExtendedOperationHandler eoh) throws Exception {
        if (this.started) {
            eoh.setLdapServer(this);
            PartitionNexus nexus = this.getDirectoryService().getPartitionNexus();
            nexus.registerSupportedExtensions(eoh.getExtensionOids());
        } else {
            this.extendedOperationHandlers.add(eoh);
        }
    }

    public void removeExtendedOperationHandler(String oid) {
        ExtendedOperationHandler handler = null;
        for (ExtendedOperationHandler h : this.extendedOperationHandlers) {
            if (!h.getOid().equals(oid)) continue;
            handler = h;
            break;
        }
        this.extendedOperationHandlers.remove(handler);
    }

    public ExtendedOperationHandler<ExtendedRequest<ExtendedResponse>, ExtendedResponse> getExtendedOperationHandler(String oid) {
        for (ExtendedOperationHandler h : this.extendedOperationHandlers) {
            if (!h.getOid().equals(oid)) continue;
            return h;
        }
        return null;
    }

    public void setConfidentialityRequired(boolean confidentialityRequired) {
        this.confidentialityRequired = confidentialityRequired;
    }

    public boolean isConfidentialityRequired() {
        return this.confidentialityRequired;
    }

    public boolean isEnableLdaps(Transport transport) {
        return transport.isSSLEnabled();
    }

    public void setMaxSizeLimit(long maxSizeLimit) {
        this.maxSizeLimit = maxSizeLimit;
    }

    public long getMaxSizeLimit() {
        return this.maxSizeLimit;
    }

    public void setMaxTimeLimit(int maxTimeLimit) {
        this.maxTimeLimit = maxTimeLimit;
    }

    public int getMaxTimeLimit() {
        return this.maxTimeLimit;
    }

    public Collection<ExtendedOperationHandler> getExtendedOperationHandlers() {
        return new ArrayList<ExtendedOperationHandler>(this.extendedOperationHandlers);
    }

    public void setExtendedOperationHandlers(Collection<ExtendedOperationHandler> handlers) {
        this.extendedOperationHandlers.clear();
        this.extendedOperationHandlers.addAll(handlers);
    }

    public String getSaslHost() {
        return this.saslHost;
    }

    public void setSaslHost(String saslHost) {
        this.saslHost = saslHost;
    }

    public String getSaslPrincipal() {
        return this.saslPrincipal;
    }

    public void setSaslPrincipal(String saslPrincipal) {
        this.saslPrincipal = saslPrincipal;
    }

    public String getSaslQopString() {
        return this.saslQopString;
    }

    public Set<String> getSaslQop() {
        return this.saslQop;
    }

    public List<String> getSaslRealms() {
        return this.saslRealms;
    }

    public void setSaslRealms(List<String> saslRealms) {
        this.saslRealms = saslRealms;
    }

    public Map<String, MechanismHandler> getSaslMechanismHandlers() {
        return this.saslMechanismHandlers;
    }

    public void setSaslMechanismHandlers(Map<String, MechanismHandler> saslMechanismHandlers) {
        this.saslMechanismHandlers = saslMechanismHandlers;
    }

    public MechanismHandler addSaslMechanismHandler(String mechanism, MechanismHandler handler) {
        return this.saslMechanismHandlers.put(mechanism, handler);
    }

    public MechanismHandler removeSaslMechanismHandler(String mechanism) {
        return this.saslMechanismHandlers.remove(mechanism);
    }

    public MechanismHandler getMechanismHandler(String mechanism) {
        return this.saslMechanismHandlers.get(mechanism);
    }

    public Set<String> getSupportedMechanisms() {
        return this.saslMechanismHandlers.keySet();
    }

    @Override
    public void setDirectoryService(DirectoryService directoryService) {
        super.setDirectoryService(directoryService);
    }

    public Set<String> getSupportedControls() {
        return this.supportedControls;
    }

    public void setSupportedControls(Set<String> supportedControls) {
        this.supportedControls = supportedControls;
    }

    public MessageHandler<AbandonRequest> getAbandonHandler() {
        return this.abandonHandler;
    }

    public void setAbandonHandler(LdapRequestHandler<AbandonRequest> abandonHandler) {
        this.handler.removeReceivedMessageHandler(AbandonRequest.class);
        this.abandonHandler = abandonHandler;
        this.abandonHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(AbandonRequest.class, this.abandonHandler);
    }

    public LdapRequestHandler<AddRequest> getAddHandler() {
        return this.addHandler;
    }

    public void setAddHandler(LdapRequestHandler<AddRequest> addHandler) {
        this.handler.removeReceivedMessageHandler(AddRequest.class);
        this.addHandler = addHandler;
        this.addHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(AddRequest.class, this.addHandler);
    }

    public LdapRequestHandler<BindRequest> getBindHandler() {
        return this.bindHandler;
    }

    public void setBindHandler(LdapRequestHandler<BindRequest> bindHandler) {
        this.bindHandler = bindHandler;
        this.bindHandler.setLdapServer(this);
        this.handler.removeReceivedMessageHandler(BindRequest.class);
        this.handler.addReceivedMessageHandler(BindRequest.class, this.bindHandler);
    }

    public LdapRequestHandler<CompareRequest> getCompareHandler() {
        return this.compareHandler;
    }

    public void setCompareHandler(LdapRequestHandler<CompareRequest> compareHandler) {
        this.handler.removeReceivedMessageHandler(CompareRequest.class);
        this.compareHandler = compareHandler;
        this.compareHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(CompareRequest.class, this.compareHandler);
    }

    public LdapRequestHandler<DeleteRequest> getDeleteHandler() {
        return this.deleteHandler;
    }

    public void setDeleteHandler(LdapRequestHandler<DeleteRequest> deleteHandler) {
        this.handler.removeReceivedMessageHandler(DeleteRequest.class);
        this.deleteHandler = deleteHandler;
        this.deleteHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(DeleteRequest.class, this.deleteHandler);
    }

    public LdapRequestHandler<ExtendedRequest<ExtendedResponse>> getExtendedHandler() {
        return this.extendedHandler;
    }

    public void setExtendedHandler(ExtendedHandler extendedHandler) {
        this.handler.removeReceivedMessageHandler(ExtendedRequest.class);
        this.extendedHandler = extendedHandler;
        this.extendedHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(ExtendedRequest.class, this.extendedHandler);
    }

    public LdapRequestHandler<ModifyRequest> getModifyHandler() {
        return this.modifyHandler;
    }

    public void setModifyHandler(LdapRequestHandler<ModifyRequest> modifyHandler) {
        this.handler.removeReceivedMessageHandler(ModifyRequest.class);
        this.modifyHandler = modifyHandler;
        this.modifyHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(ModifyRequest.class, this.modifyHandler);
    }

    public LdapRequestHandler<ModifyDnRequest> getModifyDnHandler() {
        return this.modifyDnHandler;
    }

    public void setModifyDnHandler(LdapRequestHandler<ModifyDnRequest> modifyDnHandler) {
        this.handler.removeReceivedMessageHandler(ModifyDnRequest.class);
        this.modifyDnHandler = modifyDnHandler;
        this.modifyDnHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(ModifyDnRequest.class, this.modifyDnHandler);
    }

    public LdapRequestHandler<SearchRequest> getSearchHandler() {
        return this.searchHandler;
    }

    public void setSearchHandler(LdapRequestHandler<SearchRequest> searchHandler) {
        this.handler.removeReceivedMessageHandler(SearchRequest.class);
        this.searchHandler = searchHandler;
        this.searchHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(SearchRequest.class, this.searchHandler);
    }

    public LdapRequestHandler<UnbindRequest> getUnbindHandler() {
        return this.unbindHandler;
    }

    public int getPort() {
        if (this.transports == null) {
            return -1;
        }
        for (Transport transport : this.transports) {
            if (transport instanceof UdpTransport || transport.isSSLEnabled()) continue;
            return transport.getPort();
        }
        return -1;
    }

    public int getPortSSL() {
        if (this.transports == null) {
            return -1;
        }
        for (Transport transport : this.transports) {
            if (transport instanceof UdpTransport || !transport.isSSLEnabled()) continue;
            return transport.getPort();
        }
        return -1;
    }

    public void setUnbindHandler(LdapRequestHandler<UnbindRequest> unbindHandler) {
        this.handler.removeReceivedMessageHandler(UnbindRequest.class);
        this.unbindHandler = unbindHandler;
        this.unbindHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(UnbindRequest.class, this.unbindHandler);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setStarted(boolean started) {
        this.started = started;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }

    public void setReplicationReqHandler(ReplicationRequestHandler replicationProvider) {
        this.replicationReqHandler = replicationProvider;
    }

    public void setReplConsumers(List<ReplicationConsumer> replConsumers) {
        this.replConsumers = replConsumers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LdapServer[").append(this.getServiceName()).append("], listening on :").append('\n');
        if (this.getTransports() != null) {
            for (Transport transport : this.getTransports()) {
                sb.append("    ").append(transport).append('\n');
            }
        }
        return sb.toString();
    }

    private static class AdsKeyStore
    extends KeyStore {
        public AdsKeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String type) {
            super(keyStoreSpi, provider, type);
        }
    }
}

