/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.jndi.DeadContext;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.util.JndiUtils;
import org.apache.directory.shared.util.Strings;

public class CoreContextFactory
implements InitialContextFactory {
    public synchronized Context getInitialContext(Hashtable env) throws NamingException {
        env = (Hashtable)env.clone();
        Dn principalDn = null;
        try {
            principalDn = new Dn(CoreContextFactory.getPrincipal(env));
        }
        catch (LdapInvalidDnException lide) {
            throw new InvalidNameException(I18n.err(I18n.ERR_733, env));
        }
        byte[] credential = CoreContextFactory.getCredential(env);
        String providerUrl = CoreContextFactory.getProviderUrl(env);
        DirectoryService service = (DirectoryService)env.get(DirectoryService.JNDI_KEY);
        if (service == null) {
            throw new ConfigurationException(I18n.err(I18n.ERR_477, env));
        }
        if (!service.isStarted()) {
            return new DeadContext();
        }
        ServerContext ctx = null;
        try {
            CoreSession session = service.getSession(principalDn, credential);
            ctx = new ServerLdapContext(service, session, (Name)new LdapName(providerUrl));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        ctx.lookup("");
        return ctx;
    }

    public static String getProviderUrl(Hashtable<String, Object> env) {
        Object value = env.get("java.naming.provider.url");
        if (value == null) {
            value = "";
        }
        String providerUrl = value.toString();
        env.put("java.naming.provider.url", providerUrl);
        return providerUrl;
    }

    public static String getAuthentication(Hashtable<String, Object> env) {
        Object value = env.get("java.naming.security.authentication");
        String authentication = value == null ? AuthenticationLevel.NONE.toString() : value.toString();
        env.put("java.naming.security.authentication", authentication);
        return authentication;
    }

    public static byte[] getCredential(Hashtable<String, Object> env) throws ConfigurationException {
        byte[] credential;
        Object value = env.get("java.naming.security.credentials");
        if (value == null) {
            credential = null;
        } else if (value instanceof String) {
            credential = Strings.getBytesUtf8((String)value);
        } else if (value instanceof byte[]) {
            credential = (byte[])value;
        } else {
            throw new ConfigurationException(I18n.err(I18n.ERR_478, "java.naming.security.credentials"));
        }
        if (credential != null) {
            env.put("java.naming.security.credentials", credential);
        }
        return credential;
    }

    public static String getPrincipal(Hashtable<String, Object> env) {
        String principal;
        Object value = env.get("java.naming.security.principal");
        if (value == null) {
            principal = null;
        } else {
            principal = value.toString();
            env.put("java.naming.security.principal", principal);
        }
        return principal;
    }
}

