/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitGreaterOrEqualFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitGreaterOrEqualFilter.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitGreaterOrEqualFilter() {
        super("Initialize Greater Or Equal filter");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(container.getTlvId(), 1);
        searchRequestDecorator.addCurrentFilter(filter);
        searchRequestDecorator.setTerminalFilter(filter);
        if (IS_DEBUG) {
            LOG.debug("Initialize Greater Or Equal filter");
        }
    }
}

