/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.impl.avl;

import java.net.URI;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.core.partition.impl.btree.LongComparator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndex;
import org.apache.directory.server.xdbm.EmptyIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.impl.avl.AvlTable;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.model.cursor.Tuple;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class AvlIndex<K, O>
extends AbstractIndex<K, O, Long> {
    protected Normalizer normalizer;
    protected AvlTable<K, Long> forward;
    protected AvlTable<Long, K> reverse;

    public AvlIndex() {
        super(true);
    }

    public AvlIndex(String attributeId) {
        super(attributeId, true);
    }

    public AvlIndex(String attributeId, boolean withReverse) {
        super(attributeId, withReverse);
    }

    public void init(SchemaManager schemaManager, AttributeType attributeType) throws Exception {
        this.attributeType = attributeType;
        MatchingRule mr = attributeType.getEquality();
        if (mr == null) {
            mr = attributeType.getOrdering();
        }
        if (mr == null) {
            mr = attributeType.getSubstring();
        }
        this.normalizer = mr.getNormalizer();
        if (this.normalizer == null) {
            throw new Exception(I18n.err(I18n.ERR_212, attributeType));
        }
        LdapComparator<? super Object> comp = mr.getLdapComparator();
        this.forward = new AvlTable<Object, Long>(attributeType.getName(), comp, LongComparator.INSTANCE, true);
        if (this.withReverse) {
            this.reverse = attributeType.isSingleValued() ? new AvlTable<Long, Object>(attributeType.getName(), LongComparator.INSTANCE, comp, false) : new AvlTable<Long, Object>(attributeType.getName(), LongComparator.INSTANCE, comp, true);
        }
    }

    @Override
    public void add(K attrVal, Long id) throws Exception {
        this.forward.put(attrVal, id);
        if (this.withReverse) {
            this.reverse.put(id, (Long)attrVal);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.forward != null) {
            this.forward.close();
        }
        if (this.reverse != null) {
            this.reverse.close();
        }
    }

    @Override
    public int count() throws Exception {
        return this.forward.count();
    }

    @Override
    public int count(K attrVal) throws Exception {
        return this.forward.count(attrVal);
    }

    @Override
    public void drop(Long id) throws Exception {
        if (this.withReverse) {
            Cursor<Tuple<Long, K>> cursor = this.reverse.cursor(id);
            while (cursor.next()) {
                Tuple<Long, K> tuple = cursor.get();
                this.forward.remove(tuple.getValue(), id);
            }
            cursor.close();
            this.reverse.remove(id);
        }
    }

    @Override
    public void drop(K attrVal, Long id) throws Exception {
        this.forward.remove(attrVal, id);
        if (this.withReverse) {
            this.reverse.remove(id, (Long)attrVal);
        }
    }

    @Override
    public boolean forward(K attrVal) throws Exception {
        return this.forward.has(attrVal);
    }

    @Override
    public boolean forward(K attrVal, Long id) throws Exception {
        return this.forward.has(attrVal, id);
    }

    @Override
    public IndexCursor<K, O, Long> forwardCursor() throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(), true);
    }

    @Override
    public IndexCursor<K, O, Long> forwardCursor(K key) throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(key), true);
    }

    @Override
    public boolean forwardGreaterOrEq(K attrVal) throws Exception {
        return this.forward.hasGreaterOrEqual(attrVal);
    }

    @Override
    public boolean forwardGreaterOrEq(K attrVal, Long id) throws Exception {
        return this.forward.hasGreaterOrEqual(attrVal, id);
    }

    @Override
    public boolean forwardLessOrEq(K attrVal) throws Exception {
        return this.forward.hasLessOrEqual(attrVal);
    }

    @Override
    public boolean forwardLessOrEq(K attrVal, Long id) throws Exception {
        return this.forward.hasLessOrEqual(attrVal, id);
    }

    @Override
    public Long forwardLookup(K attrVal) throws Exception {
        return this.forward.get(attrVal);
    }

    @Override
    public Cursor<Long> forwardValueCursor(K key) throws Exception {
        return this.forward.valueCursor(key);
    }

    @Override
    public int greaterThanCount(K attrVal) throws Exception {
        return this.forward.greaterThanCount(attrVal);
    }

    @Override
    public int lessThanCount(K attrVal) throws Exception {
        return this.forward.lessThanCount(attrVal);
    }

    @Override
    public boolean reverse(Long id) throws Exception {
        if (this.withReverse) {
            return this.reverse.has(id);
        }
        return false;
    }

    @Override
    public boolean reverse(Long id, K attrVal) throws Exception {
        if (this.withReverse) {
            return this.reverse.has(id, (Long)attrVal);
        }
        return false;
    }

    @Override
    public IndexCursor<K, O, Long> reverseCursor() throws Exception {
        if (this.withReverse) {
            return new IndexCursorAdaptor(this.reverse.cursor(), false);
        }
        return new EmptyIndexCursor();
    }

    @Override
    public IndexCursor<K, O, Long> reverseCursor(Long id) throws Exception {
        if (this.withReverse) {
            return new IndexCursorAdaptor(this.reverse.cursor(id), false);
        }
        return new EmptyIndexCursor();
    }

    @Override
    public boolean reverseGreaterOrEq(Long id) throws Exception {
        if (this.withReverse) {
            return this.reverse.hasGreaterOrEqual(id);
        }
        return false;
    }

    @Override
    public boolean reverseGreaterOrEq(Long id, K attrVal) throws Exception {
        if (this.withReverse) {
            return this.reverse.hasGreaterOrEqual(id, (Long)attrVal);
        }
        return false;
    }

    @Override
    public boolean reverseLessOrEq(Long id) throws Exception {
        if (this.withReverse) {
            return this.reverse.hasLessOrEqual(id);
        }
        return false;
    }

    @Override
    public boolean reverseLessOrEq(Long id, K attrVal) throws Exception {
        if (this.withReverse) {
            return this.reverse.hasLessOrEqual(id, (Long)attrVal);
        }
        return false;
    }

    @Override
    public K reverseLookup(Long id) throws Exception {
        if (this.withReverse) {
            return this.reverse.get(id);
        }
        return null;
    }

    @Override
    public Cursor<K> reverseValueCursor(Long id) throws Exception {
        if (this.withReverse) {
            return this.reverse.valueCursor(id);
        }
        return new EmptyCursor();
    }

    @Override
    public void setWkDirPath(URI wkDirPath) {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_213, new Object[0]));
    }

    @Override
    public URI getWkDirPath() {
        return null;
    }

    @Override
    public boolean isDupsEnabled() {
        if (this.withReverse) {
            return this.reverse.isDupsEnabled();
        }
        return false;
    }

    @Override
    public void sync() throws Exception {
    }
}

