/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.avltree.Position;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayTreeCursor<E>
extends AbstractCursor<E> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private ArrayTree<E> array;
    private int current;
    private Position position;

    public ArrayTreeCursor(ArrayTree<E> array) {
        LOG_CURSOR.debug("Creating ArrayTreeCursor {}", this);
        this.array = array;
        this.position = Position.BEFORE_FIRST;
    }

    @Override
    public void after(E element) throws Exception {
        this.checkNotClosed("after");
        if (element == null) {
            this.afterLast();
            return;
        }
        this.current = this.array.getAfterPosition(element);
        this.position = this.current == -1 ? Position.AFTER_LAST : Position.BEFORE_NODE;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast");
        this.current = -1;
        this.position = Position.AFTER_LAST;
    }

    @Override
    public boolean available() {
        return this.position == Position.ON_NODE;
    }

    @Override
    public void before(E element) throws Exception {
        this.checkNotClosed("before");
        if (element == null) {
            this.beforeFirst();
            return;
        }
        this.current = this.array.getBeforePosition(element);
        this.position = this.current == -1 ? Position.BEFORE_FIRST : Position.AFTER_NODE;
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst");
        this.current = -1;
        this.position = Position.BEFORE_FIRST;
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first");
        if (this.array.isEmpty()) {
            this.current = -1;
            this.position = Position.BEFORE_FIRST;
            return false;
        }
        this.current = 0;
        this.position = Position.ON_NODE;
        return true;
    }

    @Override
    public E get() throws Exception {
        this.checkNotClosed("get");
        if (this.position == Position.ON_NODE) {
            return this.array.get(this.current);
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last");
        if (this.array.isEmpty()) {
            this.current = -1;
            this.position = Position.AFTER_LAST;
            return false;
        }
        this.current = this.array.size() - 1;
        this.position = Position.ON_NODE;
        return true;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next");
        if (this.array.size() == 0) {
            return false;
        }
        switch (this.position) {
            case BEFORE_FIRST: {
                return this.first();
            }
            case BEFORE_NODE: {
                this.position = Position.ON_NODE;
                return true;
            }
            case ON_NODE: 
            case AFTER_NODE: {
                ++this.current;
                if (this.current > this.array.size() - 1) {
                    this.afterLast();
                    return false;
                }
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_LAST: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected position " + (Object)((Object)this.position));
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous");
        if (this.array.size() == 0) {
            return false;
        }
        switch (this.position) {
            case BEFORE_FIRST: {
                return false;
            }
            case BEFORE_NODE: 
            case ON_NODE: {
                --this.current;
                if (this.current < 0) {
                    this.beforeFirst();
                    return false;
                }
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_NODE: {
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_LAST: {
                return this.last();
            }
        }
        throw new IllegalStateException("Unexpected position " + (Object)((Object)this.position));
    }

    @Override
    public void close() throws Exception {
        LOG_CURSOR.debug("Closing ArrayTreeCursor {}", this);
        super.close();
    }

    @Override
    public void close(Exception reason) throws Exception {
        LOG_CURSOR.debug("Closing ArrayTreeCursor {}", this);
        super.close(reason);
    }
}

