/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.schema.registries.synchronizers;

import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchingRuleSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(MatchingRuleSynchronizer.class);

    public MatchingRuleSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    @Override
    public boolean modify(ModifyOperationContext modifyContext, Entry targetEntry, boolean cascade) throws LdapException {
        Dn name = modifyContext.getDn();
        Entry entry = modifyContext.getEntry();
        String schemaName = this.getSchemaName(name);
        MatchingRule mr = this.factory.getMatchingRule(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        String oldOid = this.getOid(entry);
        if (this.isSchemaEnabled(schemaName)) {
            this.schemaManager.unregisterMatchingRule(oldOid);
            this.schemaManager.add(mr);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void add(Entry entry) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "MatchingRule");
        this.checkOidIsUnique(entry);
        String schemaName = this.getSchemaName(dn);
        MatchingRule matchingRule = this.factory.getMatchingRule(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isEnabled() && matchingRule.isEnabled()) {
            if (this.schemaManager.add(matchingRule)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_360, entry.getDn().getName(), Strings.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The MztchingRule {} cannot be added in the disabled schema {}.", matchingRule, (Object)schemaName);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void delete(Entry entry, boolean cascade) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "MatchingRule");
        String schemaName = this.getSchemaName(entry.getDn());
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isDisabled()) {
            LOG.debug("The MatchingRule {} cannot be removed from the disabled schema {}.", (Object)dn.getName(), (Object)schemaName);
            return;
        }
        MatchingRule matchingRule = (MatchingRule)this.checkOidExists(entry);
        if (schema.isEnabled() && matchingRule.isEnabled()) {
            if (this.schemaManager.delete(matchingRule)) {
                LOG.debug("Removed {} from the schema {}", matchingRule, (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_360, entry.getDn().getName(), Strings.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("Removed {} from the disabled schema {}", matchingRule, (Object)schemaName);
    }

    @Override
    public void rename(Entry entry, Rdn newRdn, boolean cascade) throws LdapException {
        String schemaName = this.getSchemaName(entry.getDn());
        MatchingRule oldMr = this.factory.getMatchingRule(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Entry targetEntry = entry.clone();
        String newOid = newRdn.getNormValue().getString();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        MatchingRule mr = this.factory.getMatchingRule(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            this.schemaManager.unregisterMatchingRule(oldMr.getOid());
            this.schemaManager.add(mr);
        } else {
            this.unregisterOids(oldMr);
            this.registerOids(mr);
        }
    }

    @Override
    public void moveAndRename(Dn oriChildName, Dn newParentName, Rdn newRdn, boolean deleteOldRn, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        MatchingRule oldMr = this.factory.getMatchingRule(this.schemaManager, entry, this.schemaManager.getRegistries(), oldSchemaName);
        Entry targetEntry = entry.clone();
        String newOid = newRdn.getNormValue().getString();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        MatchingRule mr = this.factory.getMatchingRule(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterMatchingRule(oldMr.getOid());
        } else {
            this.unregisterOids(oldMr);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(mr);
        } else {
            this.registerOids(mr);
        }
    }

    @Override
    public void move(Dn oriChildName, Dn newParentName, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        MatchingRule oldMr = this.factory.getMatchingRule(this.schemaManager, entry, this.schemaManager.getRegistries(), oldSchemaName);
        MatchingRule newMr = this.factory.getMatchingRule(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterMatchingRule(oldMr.getOid());
        } else {
            this.unregisterOids(oldMr);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(newMr);
        } else {
            this.registerOids(newMr);
        }
    }

    private void checkNewParent(Dn newParent) throws LdapException {
        if (newParent.size() != 3) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_361, new Object[0]));
        }
        Rdn rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_362, new Object[0]));
        }
        if (!rdn.getNormValue().getString().equalsIgnoreCase("matchingRules")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_363, new Object[0]));
        }
    }
}

