/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.net.SocketAddress;
import java.security.Principal;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public final class LdapPrincipal
implements Principal,
Cloneable {
    private static final long serialVersionUID = 3906650782395676720L;
    private Dn dn = Dn.EMPTY_DN;
    private AuthenticationLevel authenticationLevel;
    private byte[] userPassword;
    private SchemaManager schemaManager;
    private SocketAddress clientAddress;
    private SocketAddress serverAddress;

    public LdapPrincipal(SchemaManager schemaManager, Dn dn, AuthenticationLevel authenticationLevel) {
        this.schemaManager = schemaManager;
        this.dn = dn;
        if (!dn.isSchemaAware()) {
            throw new IllegalStateException(I18n.err(I18n.ERR_436, new Object[0]));
        }
        this.authenticationLevel = authenticationLevel;
        this.userPassword = null;
    }

    public LdapPrincipal(SchemaManager schemaManager, Dn dn, AuthenticationLevel authenticationLevel, byte[] userPassword) {
        this.dn = dn;
        this.authenticationLevel = authenticationLevel;
        this.userPassword = new byte[userPassword.length];
        System.arraycopy(userPassword, 0, this.userPassword, 0, userPassword.length);
        this.schemaManager = schemaManager;
    }

    public LdapPrincipal() {
        this.authenticationLevel = AuthenticationLevel.NONE;
        this.userPassword = null;
    }

    public LdapPrincipal(SchemaManager schemaManager) {
        this.authenticationLevel = AuthenticationLevel.NONE;
        this.userPassword = null;
        this.schemaManager = schemaManager;
    }

    public Dn getDn() {
        return this.dn;
    }

    @Override
    public String getName() {
        return this.dn.getNormName();
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public byte[] getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(byte[] userPassword) {
        this.userPassword = new byte[userPassword.length];
        System.arraycopy(userPassword, 0, this.userPassword, 0, userPassword.length);
    }

    public Object clone() throws CloneNotSupportedException {
        LdapPrincipal clone = (LdapPrincipal)super.clone();
        if (this.userPassword != null) {
            clone.setUserPassword(this.userPassword);
        }
        return clone;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        try {
            this.dn.apply(schemaManager);
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            // empty catch block
        }
    }

    public SocketAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(SocketAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    public SocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(SocketAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.dn.isSchemaAware()) {
            sb.append("(n)");
        }
        sb.append("['");
        sb.append(this.dn.getName());
        sb.append("'");
        if (this.clientAddress != null) {
            sb.append(", client@");
            sb.append(this.clientAddress);
        }
        if (this.serverAddress != null) {
            sb.append(", server@");
            sb.append(this.serverAddress);
        }
        sb.append("]");
        return sb.toString();
    }
}

