/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.chm;

import java.util.ArrayList;
import java.util.Random;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.chm.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectableConcurrentHashMap
extends ConcurrentHashMap<Object, Element> {
    private final Random rndm = new Random();

    public SelectableConcurrentHashMap(int initialCapacity, float loadFactor, int concurrency) {
        super(initialCapacity, loadFactor, concurrency);
    }

    public Element[] getRandomValues(int size, Object keyHint) {
        ArrayList<Element> sampled = new ArrayList<Element>(size * 2);
        int randomHash = this.rndm.nextInt();
        int segmentStart = keyHint == null ? randomHash >>> this.segmentShift & this.segmentMask : SelectableConcurrentHashMap.hash(keyHint.hashCode()) >>> this.segmentShift & this.segmentMask;
        int segmentIndex = segmentStart;
        do {
            int tableStart;
            ConcurrentHashMap.HashEntry<K, V>[] table = this.segments[segmentIndex].table;
            int tableIndex = tableStart = randomHash & table.length - 1;
            do {
                ConcurrentHashMap.HashEntry e = table[tableIndex];
                while (e != null) {
                    Element value = (Element)e.value;
                    if (value != null) {
                        sampled.add(value);
                    }
                    e = e.next;
                }
                if (sampled.size() < size) continue;
                return sampled.toArray(new Element[sampled.size()]);
            } while ((tableIndex = tableIndex + 1 & table.length - 1) != tableStart);
        } while ((segmentIndex = segmentIndex + 1 & this.segmentMask) != segmentStart);
        return sampled.toArray(new Element[sampled.size()]);
    }

    public int quickSize() {
        long size = 0L;
        for (ConcurrentHashMap.Segment segment : this.segments) {
            size += (long)segment.count;
        }
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }
}

