/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.provider;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.event.EventType;
import org.apache.directory.server.core.api.event.NotificationCriteria;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.SearchAbandonListener;
import org.apache.directory.server.ldap.handlers.SearchTimeLimitingMonitor;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.server.ldap.replication.provider.ReplConsumerManager;
import org.apache.directory.server.ldap.replication.provider.ReplicaEventLog;
import org.apache.directory.server.ldap.replication.provider.ReplicaJournalCursor;
import org.apache.directory.server.ldap.replication.provider.ReplicationRequestHandler;
import org.apache.directory.server.ldap.replication.provider.SyncReplSearchListener;
import org.apache.directory.shared.ldap.extras.controls.SyncRequestValue;
import org.apache.directory.shared.ldap.extras.controls.SyncStateTypeEnum;
import org.apache.directory.shared.ldap.extras.controls.SynchronizationInfoEnum;
import org.apache.directory.shared.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncDoneValueDecorator;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncInfoValueDecorator;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncStateValueDecorator;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.model.filter.LessEqNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.message.IntermediateResponseImpl;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.ReferralImpl;
import org.apache.directory.shared.ldap.model.message.Response;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchResultDone;
import org.apache.directory.shared.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.shared.ldap.model.message.SearchResultReferenceImpl;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.message.controls.ChangeType;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.url.LdapUrl;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReplRequestHandler
implements ReplicationRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SyncReplRequestHandler.class);
    private static final Logger PROVIDER_LOG = LoggerFactory.getLogger("PROVIDER_LOG");
    private boolean initialized = false;
    private DirectoryService dirService;
    protected LdapServer ldapServer;
    private static AttributeType OBJECT_CLASS_AT;
    private Map<Integer, ReplicaEventLog> replicaLogMap = new HashMap<Integer, ReplicaEventLog>();
    private File syncReplData;
    private AtomicInteger replicaCount = new AtomicInteger(0);
    private ReplConsumerManager replicaUtil;

    @Override
    public void start(LdapServer server) {
        if (this.initialized) {
            LOG.warn("syncrepl provider was already initialized");
            PROVIDER_LOG.warn("syncrepl provider was already initialized");
            return;
        }
        try {
            LOG.info("initializing the syncrepl provider");
            PROVIDER_LOG.debug("initializing the syncrepl provider");
            this.ldapServer = server;
            this.dirService = server.getDirectoryService();
            OBJECT_CLASS_AT = this.dirService.getSchemaManager().lookupAttributeTypeRegistry("objectClass");
            File workDir = this.dirService.getInstanceLayout().getLogDirectory();
            this.syncReplData = new File(workDir, "syncrepl-data");
            if (!this.syncReplData.exists() && !this.syncReplData.mkdirs()) {
                throw new IOException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, this.syncReplData));
            }
            this.replicaUtil = new ReplConsumerManager(this.dirService);
            this.loadReplicaInfo();
            this.registerPersistentSearches();
            Thread consumerInfoUpdateThread = new Thread(this.createConsumerInfoUpdateTask());
            consumerInfoUpdateThread.setDaemon(true);
            consumerInfoUpdateThread.start();
            this.initialized = true;
            LOG.info("syncrepl provider initialized successfully");
            PROVIDER_LOG.debug("syncrepl provider initialized successfully");
        }
        catch (Exception e) {
            LOG.error("Failed to initialize the log files required by the syncrepl provider", e);
            PROVIDER_LOG.error("Failed to initialize the log files required by the syncrepl provider", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        for (ReplicaEventLog log : this.replicaLogMap.values()) {
            try {
                PROVIDER_LOG.debug("Stopping the logging for replica ", log.getId());
                log.stop();
            }
            catch (Exception e) {
                LOG.warn("Failed to close the event log {}", log.getId());
                LOG.warn("", e);
                PROVIDER_LOG.error("Failed to close the event log {}", log.getId(), (Object)e);
            }
        }
        this.initialized = false;
    }

    @Override
    public void handleSyncRequest(LdapSession session, SearchRequest request) throws LdapException {
        try {
            SyncRequestValue syncControl = (SyncRequestValue)request.getControls().get("1.3.6.1.4.1.4203.1.9.1.1");
            byte[] cookieBytes = syncControl.getCookie();
            if (cookieBytes == null) {
                PROVIDER_LOG.debug("Received a replication request {} with no cookie", request);
                this.doInitialRefresh(session, request);
            } else {
                String cookieString = Strings.utf8ToString(cookieBytes);
                PROVIDER_LOG.debug("Received a replication request {} with a cookie '{}'", request, (Object)cookieString);
                LOG.debug("search request received with the cookie {}", (Object)cookieString);
                if (!LdapProtocolUtils.isValidCookie(cookieString)) {
                    LOG.error("received a invalid cookie {} from the consumer with session {}", (Object)cookieString, (Object)session);
                    PROVIDER_LOG.debug("received a invalid cookie {} from the consumer with session {}", (Object)cookieString, (Object)session);
                    this.sendESyncRefreshRequired(session, request);
                } else {
                    ReplicaEventLog clientMsgLog = this.getReplicaEventLog(cookieString);
                    if (clientMsgLog == null) {
                        LOG.warn("received a valid cookie {} but there is no event log associated with this replica", (Object)cookieString);
                        PROVIDER_LOG.debug("received a valid cookie {} but there is no event log associated with this replica", (Object)cookieString);
                        this.sendESyncRefreshRequired(session, request);
                    } else {
                        String consumerCsn = LdapProtocolUtils.getCsn(cookieString);
                        this.doContentUpdate(session, request, clientMsgLog, consumerCsn);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to handle the syncrepl request", e);
            PROVIDER_LOG.error("Failed to handle the syncrepl request", e);
            LdapException le = new LdapException(e.getMessage(), e);
            le.initCause(e);
            throw le;
        }
    }

    private String sendContentFromLog(LdapSession session, SearchRequest req, ReplicaEventLog clientMsgLog, String consumerCsn) throws Exception {
        String lastSentCsn = clientMsgLog.getLastSentCsn();
        ReplicaJournalCursor cursor = clientMsgLog.getCursor(consumerCsn);
        PROVIDER_LOG.debug("Processing the log for replica {}", clientMsgLog.getId());
        while (cursor.next()) {
            ReplicaEventMessage replicaEventMessage = cursor.get();
            Entry entry = replicaEventMessage.getEntry();
            LOG.debug("Read message from the queue {}", entry);
            PROVIDER_LOG.debug("Read message from the queue {}", entry);
            lastSentCsn = entry.get("entryCSN").getString();
            ChangeType event = replicaEventMessage.getChangeType();
            if (event == ChangeType.MODDN) {
                this.sendSearchResultEntry(session, req, entry, SyncStateTypeEnum.MODIFY);
                continue;
            }
            SyncStateTypeEnum syncStateType = null;
            switch (event) {
                case ADD: 
                case MODIFY: {
                    syncStateType = SyncStateTypeEnum.ADD;
                    break;
                }
                case DELETE: {
                    syncStateType = SyncStateTypeEnum.DELETE;
                }
            }
            this.sendSearchResultEntry(session, req, entry, syncStateType);
        }
        PROVIDER_LOG.debug("All pending modifciations for replica {} processed", clientMsgLog.getId());
        cursor.close();
        return lastSentCsn;
    }

    private void doContentUpdate(LdapSession session, SearchRequest req, ReplicaEventLog replicaLog, String consumerCsn) throws Exception {
        boolean refreshNPersist = this.isRefreshNPersist(req);
        if (refreshNPersist) {
            SyncReplSearchListener handler = replicaLog.getPersistentListener();
            handler.setSearchRequest(req);
            handler.setSession(session);
        }
        String lastSentCsn = this.sendContentFromLog(session, req, replicaLog, consumerCsn);
        PROVIDER_LOG.debug("The latest entry sent to the consumer {} has this CSN : {}", replicaLog.getId(), (Object)lastSentCsn);
        byte[] cookie = LdapProtocolUtils.createCookie(replicaLog.getId(), lastSentCsn);
        if (refreshNPersist) {
            IntermediateResponseImpl intermResp = new IntermediateResponseImpl(req.getMessageId());
            intermResp.setResponseName("1.3.6.1.4.1.4203.1.9.1.4");
            SyncInfoValueDecorator syncInfo = new SyncInfoValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService(), SynchronizationInfoEnum.NEW_COOKIE);
            syncInfo.setCookie(cookie);
            intermResp.setResponseValue(syncInfo.getValue());
            PROVIDER_LOG.debug("Sent the intermediate response to the {} consumer, {}", replicaLog.getId(), (Object)intermResp);
            session.getIoSession().write(intermResp);
            replicaLog.getPersistentListener().setPushInRealTime(refreshNPersist);
        } else {
            SearchResultDone searchDoneResp = (SearchResultDone)req.getResultResponse();
            searchDoneResp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
            SyncDoneValueDecorator syncDone = new SyncDoneValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService());
            syncDone.setCookie(cookie);
            searchDoneResp.addControl(syncDone);
            PROVIDER_LOG.debug("Send a SearchResultDone response to the {} consumer", replicaLog.getId(), (Object)searchDoneResp);
            session.getIoSession().write(searchDoneResp);
        }
        replicaLog.setLastSentCsn(lastSentCsn);
    }

    private void doInitialRefresh(LdapSession session, SearchRequest request) throws Exception {
        String originalFilter = request.getFilter().toString();
        InetSocketAddress address = (InetSocketAddress)session.getIoSession().getRemoteAddress();
        String hostName = address.getAddress().getHostName();
        ExprNode modifiedFilter = this.modifyFilter(session, request);
        String contextCsn = this.dirService.getContextCsn();
        boolean refreshNPersist = this.isRefreshNPersist(request);
        ReplicaEventLog replicaLog = this.createRelicaEventLog(hostName, originalFilter);
        replicaLog.setRefreshNPersist(refreshNPersist);
        StringValue contexCsnValue = new StringValue(contextCsn);
        GreaterEqNode<String> csnGeNode = new GreaterEqNode<String>("entryCSN", contexCsnValue);
        AndNode postInitContentFilter = new AndNode(modifiedFilter, csnGeNode);
        request.setFilter(postInitContentFilter);
        LOG.info("starting persistent search for the client {}", replicaLog);
        PROVIDER_LOG.debug("Starting persistent search for the client {}", replicaLog);
        SyncReplSearchListener handler = new SyncReplSearchListener(session, request, replicaLog, false);
        replicaLog.setPersistentListener(handler);
        NotificationCriteria criteria = new NotificationCriteria();
        criteria.setAliasDerefMode(request.getDerefAliases());
        criteria.setBase(request.getBase());
        criteria.setFilter(request.getFilter());
        criteria.setScope(request.getScope());
        criteria.setEventMask(EventType.ALL_EVENT_TYPES_MASK);
        replicaLog.setSearchCriteria(criteria);
        this.dirService.getEventService().addListener(handler, criteria);
        LessEqNode<String> csnNode = new LessEqNode<String>("entryCSN", contexCsnValue);
        AndNode initialContentFilter = new AndNode(modifiedFilter, csnNode);
        request.setFilter(initialContentFilter);
        SearchResultDone searchDoneResp = this.doSimpleSearch(session, request);
        if (searchDoneResp.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
            replicaLog.setLastSentCsn(contextCsn);
            byte[] cookie = LdapProtocolUtils.createCookie(replicaLog.getId(), contextCsn);
            if (refreshNPersist) {
                contextCsn = this.sendContentFromLog(session, request, replicaLog, contextCsn);
                cookie = LdapProtocolUtils.createCookie(replicaLog.getId(), contextCsn);
                IntermediateResponseImpl intermResp = new IntermediateResponseImpl(request.getMessageId());
                intermResp.setResponseName("1.3.6.1.4.1.4203.1.9.1.4");
                SyncInfoValueDecorator syncInfo = new SyncInfoValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService(), SynchronizationInfoEnum.NEW_COOKIE);
                syncInfo.setCookie(cookie);
                intermResp.setResponseValue(syncInfo.getValue());
                PROVIDER_LOG.info("Sending the intermediate response to consumer {}, {}", replicaLog, (Object)syncInfo);
                session.getIoSession().write(intermResp);
                handler.setPushInRealTime(refreshNPersist);
            } else {
                SyncDoneValueDecorator syncDone = new SyncDoneValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService());
                syncDone.setCookie(cookie);
                searchDoneResp.addControl(syncDone);
                PROVIDER_LOG.info("Sending the searchResultDone response to consumer {}, {}", replicaLog, (Object)searchDoneResp);
                session.getIoSession().write(searchDoneResp);
            }
        } else {
            LOG.warn("initial content refresh didn't succeed due to {}", (Object)searchDoneResp.getLdapResult().getResultCode());
            PROVIDER_LOG.warn("initial content refresh didn't succeed due to {}", (Object)searchDoneResp.getLdapResult().getResultCode());
            replicaLog.truncate();
            replicaLog = null;
            this.dirService.getEventService().removeListener(handler);
            return;
        }
        this.replicaUtil.addConsumerEntry(replicaLog);
        this.replicaLogMap.put(replicaLog.getId(), replicaLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResultDone doSimpleSearch(LdapSession session, SearchRequest req) throws Exception {
        SearchResultDone searchDoneResp = (SearchResultDone)req.getResultResponse();
        LdapResult ldapResult = searchDoneResp.getLdapResult();
        EntryFilteringCursor cursor = session.getCoreSession().search(req);
        cursor.beforeFirst();
        try {
            long serverLimit = this.getServerSizeLimit(session, req);
            long requestLimit = req.getSizeLimit() == 0L ? Long.MAX_VALUE : req.getSizeLimit();
            req.addAbandonListener(new SearchAbandonListener(this.ldapServer, cursor));
            this.setTimeLimitsOnCursor(req, session, cursor);
            LOG.debug("using <{},{}> for size limit", requestLimit, (Object)serverLimit);
            long sizeLimit = Math.min(requestLimit, serverLimit);
            this.readResults(session, req, ldapResult, cursor, sizeLimit);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
        return searchDoneResp;
    }

    private void readResults(LdapSession session, SearchRequest req, LdapResult ldapResult, EntryFilteringCursor cursor, long sizeLimit) throws Exception {
        long count;
        for (count = 0L; count < sizeLimit && cursor.next(); ++count) {
            if (session.getIoSession().isClosing()) {
                LOG.debug("Request terminated for message {}, the client has closed the session", req.getMessageId());
                PROVIDER_LOG.debug("Request terminated for message {}, the client has closed the session", req.getMessageId());
                break;
            }
            if (req.isAbandoned()) {
                LOG.debug("Request terminated by an AbandonRequest for message {}", req.getMessageId());
                PROVIDER_LOG.debug("Request terminated by an AbandonRequest for message {}", req.getMessageId());
                break;
            }
            Entry entry = (Entry)cursor.get();
            this.sendSearchResultEntry(session, req, entry, SyncStateTypeEnum.ADD);
        }
        ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        if (count >= sizeLimit && cursor.next()) {
            cursor.previous();
            ldapResult.setResultCode(ResultCodeEnum.SIZE_LIMIT_EXCEEDED);
        }
    }

    private void sendSearchResultEntry(LdapSession session, SearchRequest req, Entry entry, SyncStateTypeEnum syncStateType) throws Exception {
        Attribute uuid = entry.get("entryUUID");
        SyncStateValueDecorator syncStateControl = new SyncStateValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService());
        syncStateControl.setSyncStateType(syncStateType);
        syncStateControl.setEntryUUID(Strings.uuidToBytes(uuid.getString()));
        if (syncStateType == SyncStateTypeEnum.DELETE) {
            entry.clear();
            entry.add(uuid);
        }
        Response resp = this.generateResponse(session, req, entry);
        resp.addControl(syncStateControl);
        LOG.debug("Sending {}", entry.getDn());
        PROVIDER_LOG.debug("Sending the entry: {}", entry);
        session.getIoSession().write(resp);
    }

    private Response generateResponse(LdapSession session, SearchRequest req, Entry entry) throws Exception {
        Attribute ref = entry.get("ref");
        boolean hasManageDsaItControl = req.getControls().containsKey("2.16.840.1.113730.3.4.2");
        if (ref != null && !hasManageDsaItControl) {
            SearchResultReferenceImpl respRef = new SearchResultReferenceImpl(req.getMessageId());
            respRef.setReferral(new ReferralImpl());
            for (Value val : ref) {
                String url = val.getString();
                if (!url.startsWith("ldap")) {
                    respRef.getReferral().addLdapUrl(url);
                }
                LdapUrl ldapUrl = null;
                try {
                    ldapUrl = new LdapUrl(url);
                    ldapUrl.setForceScopeRendering(true);
                }
                catch (LdapURLEncodingException e) {
                    LOG.error(I18n.err(I18n.ERR_165, url, entry));
                }
                switch (req.getScope()) {
                    case SUBTREE: {
                        ldapUrl.setScope(SearchScope.SUBTREE.getScope());
                        break;
                    }
                    case ONELEVEL: {
                        ldapUrl.setScope(SearchScope.OBJECT.getScope());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(I18n.err(I18n.ERR_686, new Object[0]));
                    }
                }
                respRef.getReferral().addLdapUrl(ldapUrl.toString());
            }
            return respRef;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(req.getMessageId());
        respEntry.setEntry(entry);
        respEntry.setObjectName(entry.getDn());
        return respEntry;
    }

    private long getServerSizeLimit(LdapSession session, SearchRequest request) {
        if (session.getCoreSession().isAnAdministrator()) {
            if (request.getSizeLimit() == 0L) {
                return Long.MAX_VALUE;
            }
            return request.getSizeLimit();
        }
        if (this.ldapServer.getMaxSizeLimit() == 0L) {
            return Long.MAX_VALUE;
        }
        return this.ldapServer.getMaxSizeLimit();
    }

    private void setTimeLimitsOnCursor(SearchRequest req, LdapSession session, EntryFilteringCursor cursor) {
        if (session.getCoreSession().isAnAdministrator() && req.getTimeLimit() == 0) {
            return;
        }
        if (this.ldapServer.getMaxTimeLimit() == 0 && req.getTimeLimit() == 0) {
            return;
        }
        if (req.getTimeLimit() == 0) {
            cursor.setClosureMonitor(new SearchTimeLimitingMonitor(this.ldapServer.getMaxTimeLimit(), TimeUnit.SECONDS));
            return;
        }
        if (this.ldapServer.getMaxTimeLimit() >= req.getTimeLimit()) {
            cursor.setClosureMonitor(new SearchTimeLimitingMonitor(req.getTimeLimit(), TimeUnit.SECONDS));
            return;
        }
        cursor.setClosureMonitor(new SearchTimeLimitingMonitor(this.ldapServer.getMaxTimeLimit(), TimeUnit.SECONDS));
    }

    public ExprNode modifyFilter(LdapSession session, SearchRequest req) throws Exception {
        boolean isOcPresenceFilter = false;
        if (req.getFilter() instanceof PresenceNode) {
            PresenceNode presenceNode = (PresenceNode)req.getFilter();
            AttributeType at = session.getCoreSession().getDirectoryService().getSchemaManager().lookupAttributeTypeRegistry(presenceNode.getAttribute());
            if (at.getOid().equals("2.5.4.0")) {
                isOcPresenceFilter = true;
            }
        }
        ExprNode filter = req.getFilter();
        if (!req.hasControl("2.16.840.1.113730.3.4.2") && !isOcPresenceFilter) {
            filter = new OrNode(req.getFilter(), this.newIsReferralEqualityNode(session));
        }
        return filter;
    }

    private EqualityNode<String> newIsReferralEqualityNode(LdapSession session) throws Exception {
        EqualityNode<String> ocIsReferral = new EqualityNode<String>("objectClass", new StringValue(OBJECT_CLASS_AT, "referral"));
        return ocIsReferral;
    }

    private void storeReplicaInfo() {
        try {
            for (Map.Entry<Integer, ReplicaEventLog> e : this.replicaLogMap.entrySet()) {
                ReplicaEventLog replica = e.getValue();
                if (!replica.isDirty()) continue;
                LOG.debug("updating the details of replica {}", replica);
                PROVIDER_LOG.debug("updating the details of replica {}", replica);
                this.replicaUtil.updateReplicaLastSentCsn(replica);
                replica.setDirty(false);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to store the replica information", e);
            PROVIDER_LOG.error("Failed to store the replica information", e);
        }
    }

    private void loadReplicaInfo() {
        try {
            List<ReplicaEventLog> eventLogs = this.replicaUtil.getReplicaEventLogs();
            if (!eventLogs.isEmpty()) {
                for (ReplicaEventLog replica : eventLogs) {
                    LOG.debug("initializing the replica log from {}", replica.getId());
                    PROVIDER_LOG.debug("initializing the replica log from {}", replica.getId());
                    this.replicaLogMap.put(replica.getId(), replica);
                    if (this.replicaCount.get() >= replica.getId()) continue;
                    this.replicaCount.set(replica.getId());
                }
            } else {
                LOG.debug("no replica logs found to initialize");
                PROVIDER_LOG.debug("no replica logs found to initialize");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to load the replica information", e);
            PROVIDER_LOG.error("Failed to load the replica information", e);
        }
    }

    private void registerPersistentSearches() throws Exception {
        for (Map.Entry<Integer, ReplicaEventLog> e : this.replicaLogMap.entrySet()) {
            ReplicaEventLog log = e.getValue();
            if (log.getSearchCriteria() != null) {
                LOG.debug("registering peristent search for the replica {}", log.getId());
                PROVIDER_LOG.debug("registering peristent search for the replica {}", log.getId());
                SyncReplSearchListener handler = new SyncReplSearchListener(null, null, log, false);
                log.setPersistentListener(handler);
                this.dirService.getEventService().addListener(handler, log.getSearchCriteria());
                continue;
            }
            LOG.warn("invalid peristent search criteria {} for the replica {}", log.getSearchCriteria(), (Object)log.getId());
            PROVIDER_LOG.warn("invalid peristent search criteria {} for the replica {}", log.getSearchCriteria(), (Object)log.getId());
        }
    }

    private Runnable createConsumerInfoUpdateTask() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    SyncReplRequestHandler.this.storeReplicaInfo();
                    try {
                        Thread.sleep(10000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOG.warn("thread storing the replica information was interrupted", e);
                        PROVIDER_LOG.warn("thread storing the replica information was interrupted", e);
                        continue;
                    }
                    break;
                }
            }
        };
        return task;
    }

    private ReplicaEventLog getReplicaEventLog(String cookieString) throws Exception {
        ReplicaEventLog replicaLog = null;
        if (LdapProtocolUtils.isValidCookie(cookieString)) {
            int clientId = LdapProtocolUtils.getReplicaId(cookieString);
            replicaLog = this.replicaLogMap.get(clientId);
        }
        return replicaLog;
    }

    private ReplicaEventLog createRelicaEventLog(String hostName, String filter) throws Exception {
        int replicaId = this.replicaCount.incrementAndGet();
        LOG.debug("creating a new event log for the replica with id {}", replicaId);
        ReplicaEventLog replicaLog = new ReplicaEventLog(this.dirService, replicaId);
        replicaLog.setHostName(hostName);
        replicaLog.setSearchFilter(filter);
        return replicaLog;
    }

    private void sendESyncRefreshRequired(LdapSession session, SearchRequest req) throws Exception {
        SearchResultDone searchDoneResp = (SearchResultDone)req.getResultResponse();
        searchDoneResp.getLdapResult().setResultCode(ResultCodeEnum.E_SYNC_REFRESH_REQUIRED);
        SyncDoneValueDecorator syncDone = new SyncDoneValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService());
        searchDoneResp.addControl(syncDone);
        session.getIoSession().write(searchDoneResp);
    }

    private boolean isRefreshNPersist(SearchRequest req) {
        SyncRequestValue control = (SyncRequestValue)req.getControls().get("1.3.6.1.4.1.4203.1.9.1.1");
        return control.getMode() == SynchronizationModeEnum.REFRESH_AND_PERSIST;
    }
}

