/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.DeleteResponse;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHandler
extends LdapRequestHandler<DeleteRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteHandler.class);

    @Override
    public void handle(LdapSession session, DeleteRequest req) {
        LOG.debug("Handling request: {}", req);
        LdapResult result = ((DeleteResponse)req.getResultResponse()).getLdapResult();
        try {
            CoreSession coreSession = session.getCoreSession();
            coreSession.delete(req);
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write(req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, req, e);
        }
    }
}

