/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.util.ArrayList;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.ReferralManager;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.GetRootDseOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapAffectMultipleDsaException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.shared.ldap.model.exception.LdapPartialResultException;
import org.apache.directory.shared.ldap.model.exception.LdapReferralException;
import org.apache.directory.shared.ldap.model.exception.LdapServiceUnavailableException;
import org.apache.directory.shared.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.url.LdapUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOperationManager
implements OperationManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOperationManager.class);
    private static final Logger LOG_CHANGES = LoggerFactory.getLogger("LOG_CHANGES");
    private final DirectoryService directoryService;

    public DefaultOperationManager(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    private void eagerlyPopulateFields(OperationContext opContext) throws LdapException {
        if (opContext.getEntry() == null) {
            CoreSession adminSession = opContext.getSession().getDirectoryService().getAdminSession();
            LookupOperationContext lookupContext = new LookupOperationContext(adminSession, opContext.getDn(), SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            Entry foundEntry = opContext.getSession().getDirectoryService().getPartitionNexus().lookup(lookupContext);
            if (foundEntry != null) {
                opContext.setEntry(foundEntry);
            } else {
                LdapNoSuchObjectException ldnfe = new LdapNoSuchObjectException(I18n.err(I18n.ERR_256_NO_SUCH_OBJECT, opContext.getDn()));
                throw ldnfe;
            }
        }
    }

    private Entry getOriginalEntry(OperationContext opContext) throws LdapException {
        CoreSession adminSession = opContext.getSession().getDirectoryService().getAdminSession();
        Entry foundEntry = adminSession.lookup(opContext.getDn(), "+", "*");
        if (foundEntry != null) {
            return foundEntry;
        }
        LdapNoSuchObjectException ldnfe = new LdapNoSuchObjectException(I18n.err(I18n.ERR_256_NO_SUCH_OBJECT, opContext.getDn()));
        throw ldnfe;
    }

    private LdapReferralException buildReferralException(Entry parentEntry, Dn childDn) throws LdapException {
        Attribute refs = parentEntry.get("ref");
        ArrayList<String> urls = new ArrayList<String>();
        try {
            for (Value url : refs) {
                LdapUrl ldapUrl = new LdapUrl(url.getString());
                Dn urlDn = ldapUrl.getDn().add(childDn);
                ldapUrl.setDn(urlDn);
                urls.add(ldapUrl.toString());
            }
        }
        catch (LdapURLEncodingException luee) {
            throw new LdapOperationErrorException(luee.getMessage(), luee);
        }
        LdapReferralException lre = new LdapReferralException(urls);
        lre.setRemainingDn(childDn);
        lre.setResolvedDn(parentEntry.getDn());
        lre.setResolvedObject(parentEntry);
        return lre;
    }

    private LdapReferralException buildReferralExceptionForSearch(Entry parentEntry, Dn childDn, SearchScope scope) throws LdapException {
        Attribute refs = parentEntry.get("ref");
        ArrayList<String> urls = new ArrayList<String>();
        for (Value url : refs) {
            try {
                LdapUrl ldapUrl = new LdapUrl(url.getString());
                StringBuilder urlString = new StringBuilder();
                if (ldapUrl.getDn() == null || ldapUrl.getDn() == Dn.ROOT_DSE) {
                    ldapUrl.setDn(parentEntry.getDn());
                } else {
                    Dn urlDn = ldapUrl.getDn().add(childDn);
                    ldapUrl.setDn(urlDn);
                }
                urlString.append(ldapUrl.toString()).append("??");
                switch (scope) {
                    case OBJECT: {
                        urlString.append("base");
                        break;
                    }
                    case SUBTREE: {
                        urlString.append("sub");
                        break;
                    }
                    case ONELEVEL: {
                        urlString.append("one");
                    }
                }
                urls.add(urlString.toString());
            }
            catch (LdapURLEncodingException luee) {
                urls.add(url.getString());
            }
        }
        LdapReferralException lre = new LdapReferralException(urls);
        lre.setRemainingDn(childDn);
        lre.setResolvedDn(parentEntry.getDn());
        lre.setResolvedObject(parentEntry);
        return lre;
    }

    private LdapPartialResultException buildLdapPartialResultException(Dn childDn) {
        LdapPartialResultException lpre = new LdapPartialResultException(I18n.err(I18n.ERR_315, new Object[0]));
        lpre.setRemainingDn(childDn);
        lpre.setResolvedDn(Dn.EMPTY_DN);
        return lpre;
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        LOG.debug(">> AddOperation : {}", addContext);
        LOG_CHANGES.debug(">> AddOperation : {}", addContext);
        this.ensureStarted();
        Dn dn = addContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            Dn childDn = dn.getDescendantOf(parentEntry.getDn());
            if (addContext.isReferralIgnored()) {
                this.directoryService.getReferralManager().unlock();
                LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                throw exception;
            }
            this.directoryService.getReferralManager().unlock();
            LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
            throw exception;
        }
        this.directoryService.getReferralManager().unlock();
        Interceptor head = this.directoryService.getInterceptor(addContext.getNextInterceptor());
        head.add(addContext);
        LOG.debug("<< AddOperation successful");
        LOG_CHANGES.debug("<< AddOperation successful");
    }

    @Override
    public void bind(BindOperationContext bindContext) throws LdapException {
        LOG.debug(">> BindOperation : {}", bindContext);
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(bindContext.getNextInterceptor());
        head.bind(bindContext);
        LOG.debug("<< BindOperation successful");
    }

    @Override
    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        LOG.debug(">> CompareOperation : {}", compareContext);
        this.ensureStarted();
        Dn dn = compareContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
        if (parentEntry != null) {
            Dn childDn = dn.getDescendantOf(parentEntry.getDn());
            if (this.directoryService.getReferralManager().isReferral(dn)) {
                if (!compareContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                if (compareContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                    throw exception;
                }
                this.directoryService.getReferralManager().unlock();
                LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                throw exception;
            }
        }
        this.directoryService.getReferralManager().unlock();
        compareContext.setOriginalEntry(this.getOriginalEntry(compareContext));
        Interceptor head = this.directoryService.getInterceptor(compareContext.getNextInterceptor());
        boolean result = head.compare(compareContext);
        LOG.debug("<< CompareOperation successful");
        return result;
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        LOG.debug(">> DeleteOperation : {}", deleteContext);
        LOG_CHANGES.debug(">> DeleteOperation : {}", deleteContext);
        this.ensureStarted();
        Dn dn = deleteContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
        if (parentEntry != null) {
            Dn childDn = dn.getDescendantOf(parentEntry.getDn());
            if (this.directoryService.getReferralManager().isReferral(dn)) {
                if (!deleteContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                if (deleteContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                    throw exception;
                }
                this.directoryService.getReferralManager().unlock();
                LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                throw exception;
            }
        }
        this.directoryService.getReferralManager().unlock();
        this.eagerlyPopulateFields(deleteContext);
        Interceptor head = this.directoryService.getInterceptor(deleteContext.getNextInterceptor());
        head.delete(deleteContext);
        LOG.debug("<< DeleteOperation successful");
        LOG_CHANGES.debug("<< DeleteOperation successful");
    }

    @Override
    public Entry getRootDse(GetRootDseOperationContext getRootDseContext) throws LdapException {
        LOG.debug(">> GetRootDseOperation : {}", getRootDseContext);
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(getRootDseContext.getNextInterceptor());
        Entry root = head.getRootDse(getRootDseContext);
        LOG.debug("<< getRootDseOperation successful");
        return root;
    }

    @Override
    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        LOG.debug(">> hasEntryOperation : {}", hasEntryContext);
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(hasEntryContext.getNextInterceptor());
        boolean result = head.hasEntry(hasEntryContext);
        LOG.debug("<< HasEntryOperation successful");
        return result;
    }

    @Override
    public EntryFilteringCursor list(ListOperationContext listContext) throws LdapException {
        LOG.debug(">> ListOperation : {}", listContext);
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(listContext.getNextInterceptor());
        EntryFilteringCursor cursor = head.list(listContext);
        LOG.debug("<< ListOperation successful");
        return cursor;
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        LOG.debug(">> LookupOperation : {}", lookupContext);
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(lookupContext.getNextInterceptor());
        Entry entry = head.lookup(lookupContext);
        LOG.debug("<< LookupOperation successful");
        return entry;
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        LOG.debug(">> ModifyOperation : {}", modifyContext);
        LOG_CHANGES.debug(">> ModifyOperation : {}", modifyContext);
        this.ensureStarted();
        Dn dn = modifyContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        ReferralManager referralManager = this.directoryService.getReferralManager();
        referralManager.lockRead();
        Entry parentEntry = referralManager.getParentReferral(dn);
        if (parentEntry != null) {
            if (referralManager.isReferral(dn)) {
                if (!modifyContext.isReferralIgnored()) {
                    referralManager.unlock();
                    Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            } else if (referralManager.hasParentReferral(dn)) {
                if (modifyContext.isReferralIgnored()) {
                    referralManager.unlock();
                    Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                    LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                    throw exception;
                }
                referralManager.unlock();
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                throw exception;
            }
        }
        referralManager.unlock();
        this.eagerlyPopulateFields(modifyContext);
        Interceptor head = this.directoryService.getInterceptor(modifyContext.getNextInterceptor());
        head.modify(modifyContext);
        LOG.debug("<< ModifyOperation successful");
        LOG_CHANGES.debug("<< ModifyOperation successful");
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        LOG.debug(">> MoveOperation : {}", moveContext);
        LOG_CHANGES.debug(">> MoveOperation : {}", moveContext);
        this.ensureStarted();
        Dn dn = moveContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        Dn newSuperiorDn = moveContext.getNewSuperior();
        newSuperiorDn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
        if (parentEntry != null) {
            Dn childDn = dn.getDescendantOf(parentEntry.getDn());
            if (this.directoryService.getReferralManager().isReferral(dn)) {
                if (!moveContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                if (moveContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                    throw exception;
                }
                this.directoryService.getReferralManager().unlock();
                LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                throw exception;
            }
        }
        if (this.directoryService.getReferralManager().isReferral(newSuperiorDn) || this.directoryService.getReferralManager().hasParentReferral(newSuperiorDn)) {
            this.directoryService.getReferralManager().unlock();
            LdapAffectMultipleDsaException exception = new LdapAffectMultipleDsaException();
            throw exception;
        }
        this.directoryService.getReferralManager().unlock();
        Entry originalEntry = this.getOriginalEntry(moveContext);
        moveContext.setOriginalEntry(originalEntry);
        Interceptor head = this.directoryService.getInterceptor(moveContext.getNextInterceptor());
        head.move(moveContext);
        LOG.debug("<< MoveOperation successful");
        LOG_CHANGES.debug("<< MoveOperation successful");
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        LOG.debug(">> MoveAndRenameOperation : {}", moveAndRenameContext);
        LOG_CHANGES.debug(">> MoveAndRenameOperation : {}", moveAndRenameContext);
        this.ensureStarted();
        Dn dn = moveAndRenameContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
        if (parentEntry != null) {
            Dn childDn = dn.getDescendantOf(parentEntry.getDn());
            if (this.directoryService.getReferralManager().isReferral(dn)) {
                if (!moveAndRenameContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                if (moveAndRenameContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                    throw exception;
                }
                this.directoryService.getReferralManager().unlock();
                LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                throw exception;
            }
        }
        Dn newSuperiorDn = moveAndRenameContext.getNewSuperiorDn();
        newSuperiorDn.apply(this.directoryService.getSchemaManager());
        if (this.directoryService.getReferralManager().isReferral(newSuperiorDn) || this.directoryService.getReferralManager().hasParentReferral(newSuperiorDn)) {
            this.directoryService.getReferralManager().unlock();
            LdapAffectMultipleDsaException exception = new LdapAffectMultipleDsaException();
            throw exception;
        }
        this.directoryService.getReferralManager().unlock();
        moveAndRenameContext.setOriginalEntry(this.getOriginalEntry(moveAndRenameContext));
        moveAndRenameContext.setModifiedEntry(moveAndRenameContext.getOriginalEntry().clone());
        Interceptor head = this.directoryService.getInterceptor(moveAndRenameContext.getNextInterceptor());
        head.moveAndRename(moveAndRenameContext);
        LOG.debug("<< MoveAndRenameOperation successful");
        LOG_CHANGES.debug("<< MoveAndRenameOperation successful");
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        LOG.debug(">> RenameOperation : {}", renameContext);
        LOG_CHANGES.debug(">> RenameOperation : {}", renameContext);
        this.ensureStarted();
        Dn dn = renameContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        if (!dn.isEmpty()) {
            Dn newDn = dn.getParent();
            newDn = newDn.add(renameContext.getNewRdn());
            renameContext.setNewDn(newDn);
        }
        this.directoryService.getReferralManager().lockRead();
        Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
        if (parentEntry != null) {
            Dn childDn = dn.getDescendantOf(parentEntry.getDn());
            if (this.directoryService.getReferralManager().isReferral(dn)) {
                if (!renameContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                if (renameContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                    throw exception;
                }
                this.directoryService.getReferralManager().unlock();
                LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                throw exception;
            }
        }
        this.directoryService.getReferralManager().unlock();
        this.eagerlyPopulateFields(renameContext);
        Entry originalEntry = this.getOriginalEntry(renameContext);
        renameContext.setOriginalEntry(originalEntry);
        renameContext.setModifiedEntry(originalEntry.clone());
        Interceptor head = this.directoryService.getInterceptor(renameContext.getNextInterceptor());
        head.rename(renameContext);
        LOG.debug("<< RenameOperation successful");
        LOG_CHANGES.debug("<< RenameOperation successful");
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        LOG.debug(">> SearchOperation : {}", searchContext);
        this.ensureStarted();
        Dn dn = searchContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
        if (parentEntry != null) {
            Dn childDn = dn.getDescendantOf(parentEntry.getDn());
            if (this.directoryService.getReferralManager().isReferral(dn)) {
                if (!searchContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralExceptionForSearch(parentEntry, childDn, searchContext.getScope());
                    throw exception;
                }
            } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                if (searchContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                    throw exception;
                }
                this.directoryService.getReferralManager().unlock();
                LdapReferralException exception = this.buildReferralExceptionForSearch(parentEntry, childDn, searchContext.getScope());
                throw exception;
            }
        }
        this.directoryService.getReferralManager().unlock();
        Interceptor head = this.directoryService.getInterceptor(searchContext.getNextInterceptor());
        EntryFilteringCursor cursor = head.search(searchContext);
        LOG.debug("<< SearchOperation successful");
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(UnbindOperationContext unbindContext) throws LdapException {
        LOG.debug(">> UnbindOperation : {}", unbindContext);
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(unbindContext.getNextInterceptor());
        head.unbind(unbindContext);
        LOG.debug("<< UnbindOperation successful");
    }

    private void ensureStarted() throws LdapServiceUnavailableException {
        if (!this.directoryService.isStarted()) {
            throw new LdapServiceUnavailableException(ResultCodeEnum.UNAVAILABLE, I18n.err(I18n.ERR_316, new Object[0]));
        }
    }
}

