/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.parsers.AbstractSchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSyntaxDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(LdapSyntaxDescriptionSchemaParser.class);

    public synchronized LdapSyntax parseLdapSyntaxDescription(String ldapSyntaxDescription) throws ParseException {
        LOG.debug("Parsing a LdapSyntax : {}", (Object)ldapSyntaxDescription);
        if (ldapSyntaxDescription == null) {
            LOG.error(I18n.err(I18n.ERR_04239, new Object[0]));
            throw new ParseException("Null", 0);
        }
        this.reset(ldapSyntaxDescription);
        try {
            LdapSyntax ldapSyntax = this.parser.ldapSyntaxDescription();
            ldapSyntax.setSpecification(ldapSyntaxDescription);
            LdapSyntaxDescriptionSchemaParser.updateSchemaName(ldapSyntax);
            return ldapSyntax;
        }
        catch (RecognitionException re) {
            String msg = I18n.err(I18n.ERR_04240, ldapSyntaxDescription, re.getMessage(), re.getColumn());
            LOG.error(msg);
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err(I18n.ERR_04241, ldapSyntaxDescription, tse.getMessage());
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    public LdapSyntax parse(String schemaDescription) throws ParseException {
        return this.parseLdapSyntaxDescription(schemaDescription);
    }
}

