/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.interceptor.context.AbstractOperationContext;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;

public class LookupOperationContext
extends AbstractOperationContext {
    private static final String[] EMPTY = new String[0];
    private List<String> attrsId = new ArrayList<String>();
    private Boolean allOperational;
    private Boolean allUser;
    private Boolean noAttribute;

    public LookupOperationContext(CoreSession session) {
        super(session);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.LOOKUP));
        }
    }

    public LookupOperationContext(CoreSession session, Dn dn) {
        super(session, dn);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.LOOKUP));
        }
    }

    public LookupOperationContext(CoreSession session, String[] attrsId) {
        super(session);
        this.setAttrsId(attrsId);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.LOOKUP));
        }
    }

    public LookupOperationContext(CoreSession session, Dn dn, String[] attrsId) {
        super(session, dn);
        this.setAttrsId(attrsId);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.LOOKUP));
        }
    }

    public String[] getAttrsIdArray() {
        if (this.attrsId == null || this.attrsId.size() == 0) {
            return EMPTY;
        }
        String[] attrs = new String[this.attrsId.size()];
        return this.attrsId.toArray(attrs);
    }

    public void setAttrsId(String[] attrsId) {
        if (attrsId != null && attrsId.length > 0) {
            this.attrsId = new ArrayList<String>(Arrays.asList(attrsId));
            int nbNoAttribute = 0;
            for (String id : this.attrsId) {
                if (id.equals("+")) {
                    this.allOperational = true;
                    continue;
                }
                if (id.equals("*")) {
                    this.allUser = true;
                    continue;
                }
                if (!id.equals("1.1")) continue;
                this.noAttribute = true;
                ++nbNoAttribute;
            }
            if (this.allOperational != null && this.allOperational.booleanValue()) {
                this.attrsId.remove("+");
            }
            if (this.allUser != null && this.allUser.booleanValue()) {
                this.attrsId.remove("*");
            }
            if (this.noAttribute != null) {
                if (attrsId.length == nbNoAttribute) {
                    this.attrsId.clear();
                } else {
                    this.attrsId.remove("1.1");
                    this.noAttribute = false;
                }
            }
        }
    }

    public void addAttrsId(String attrId) {
        if (this.noAttribute == null) {
            if (attrId.equals("1.1")) {
                this.noAttribute = true;
                if (this.attrsId != null) {
                    this.attrsId.clear();
                }
                return;
            }
            if (attrId.equals("*")) {
                this.allUser = true;
                return;
            }
            if (attrId.equals("+")) {
                this.allOperational = true;
                return;
            }
            if (this.attrsId == null) {
                this.attrsId = new ArrayList<String>();
            }
            this.attrsId.add(attrId);
        }
    }

    public List<String> getAttrsId() {
        return this.attrsId;
    }

    public boolean hasAllUser() {
        return this.allUser != null && this.allUser != false;
    }

    public boolean hasAllOperational() {
        return this.allOperational != null && this.allOperational != false;
    }

    public boolean hasNoAttribute() {
        return this.noAttribute != null;
    }

    @Override
    public String getName() {
        return "Lookup";
    }

    public String toString() {
        return "LookupContext for Dn '" + this.getDn().getName() + "'" + (this.attrsId != null ? ", attributes : <" + Strings.listToString(this.attrsId) + ">" : "");
    }
}

